/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.math;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

public abstract class AbstractMathAction
extends AbstractActionMetadata
implements ColumnAction {
    protected static final String ERROR_RESULT = "";

    @Override
    public boolean acceptField(Schema.Field field) {
        Type columnType = Type.get((String)RowMetadataUtils.toColumnMetadata((Schema.Field)field).getType());
        return Type.NUMERIC.isAssignableFrom(columnType);
    }

    @Override
    public String getCategory() {
        return ActionCategory.MATH.getDisplayName();
    }

    protected abstract String getColumnNameSuffix(Map<String, String> var1);

    @Override
    public void compile(ActionContext context) {
        super.compile(context);
        if (context.getActionStatus() == ActionContext.ActionStatus.OK) {
            String columnId = context.getColumnId();
            RowMetadata rowMetadata = context.getRowMetadata();
            ColumnMetadata column = rowMetadata.getById(columnId);
            context.column("result", r -> {
                ColumnMetadata c = ColumnMetadata.Builder.column().name(column.getName() + "_" + this.getColumnNameSuffix(context.getParameters())).type(Type.STRING).build();
                rowMetadata.insertAfter(columnId, c);
                return c;
            });
        }
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return Collections.singleton(ActionDefinition.Behavior.METADATA_CREATE_COLUMNS);
    }
}

