/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.math;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.daikon.exception.ExceptionContext;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.exception.error.ErrorCode;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.exception.error.ActionErrorCodes;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.parameters.ParameterType;
import org.talend.dataprep.parameters.SelectParameter;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.actions.math.AbstractMathAction;
import org.talend.dataprep.transformation.actions.math.ExtractNumber;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

public abstract class AbstractMathOneParameterAction
extends AbstractMathAction
implements ColumnAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMathOneParameterAction.class);
    private static final String DEFAULT_VALUE_NAN = Integer.toString(Integer.MAX_VALUE);

    @Override
    public List<Parameter> getParameters() {
        List<Parameter> parameters = super.getParameters();
        parameters.add((Parameter)SelectParameter.Builder.builder().name("mode").item("constant_mode", new Parameter[]{new Parameter("constant_value", ParameterType.STRING, "")}).item("other_column_mode", new Parameter[]{new Parameter("selected_column", ParameterType.COLUMN, "", false, false, "")}).defaultValue("constant_mode").build());
        return parameters;
    }

    protected abstract String calculateResult(String var1, String var2);

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        String parameterValue;
        String mode;
        String columnId = context.getColumnId();
        String colValue = row.get(columnId);
        Map parameters = context.getParameters();
        switch (mode = (String)parameters.get("mode")) {
            case "constant_mode": {
                parameterValue = (String)parameters.get("constant_value");
                break;
            }
            case "other_column_mode": {
                String otherColId = (String)parameters.get("selected_column");
                parameterValue = row.get(otherColId);
                break;
            }
            default: {
                throw new TalendRuntimeException((ErrorCode)ActionErrorCodes.BAD_ACTION_PARAMETER, ExceptionContext.build().put("paramName", (Object)"constant_mode"));
            }
        }
        String result = "";
        try {
            if (NumberUtils.isNumber((String)colValue) && NumberUtils.isNumber((String)parameterValue)) {
                result = this.calculateResult(colValue, parameterValue);
            } else {
                if (!NumberUtils.isNumber((String)parameterValue)) {
                    parameterValue = ExtractNumber.extractNumber(parameterValue, DEFAULT_VALUE_NAN);
                }
                if (!NumberUtils.isNumber((String)colValue)) {
                    colValue = ExtractNumber.extractNumber(colValue, DEFAULT_VALUE_NAN);
                }
                if (!StringUtils.equals((String)DEFAULT_VALUE_NAN, (String)parameterValue) && !StringUtils.equals((String)DEFAULT_VALUE_NAN, (String)colValue)) {
                    result = this.calculateResult(colValue, parameterValue);
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        String newColumnId = context.column("result");
        row.set(newColumnId, result);
    }
}

