/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.math;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.avro.Schema;
import org.talend.daikon.number.BigDecimalParser;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.parameters.ParameterType;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

public abstract class AbstractRound
extends AbstractActionMetadata
implements ColumnAction {
    protected static final String PRECISION = "precision";

    @Override
    public String getCategory() {
        return ActionCategory.NUMBERS.getDisplayName();
    }

    @Override
    public List<Parameter> getParameters() {
        List<Parameter> parameters = super.getParameters();
        parameters.add(new Parameter(PRECISION, ParameterType.INTEGER, "0"));
        return parameters;
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        String columnId;
        String value;
        String precisionAsString = (String)context.getParameters().get(PRECISION);
        int precision = 0;
        try {
            precision = Integer.parseInt(precisionAsString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (precision < 0) {
            precision = 0;
        }
        if ((value = row.get(columnId = context.getColumnId())) == null) {
            return;
        }
        try {
            BigDecimal bd = BigDecimalParser.toBigDecimal((String)value);
            bd = bd.setScale(precision, this.getRoundingMode());
            row.set(columnId, String.valueOf(bd));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected abstract RoundingMode getRoundingMode();

    @Override
    public boolean acceptField(Schema.Field field) {
        ColumnMetadata column = RowMetadataUtils.toColumnMetadata((Schema.Field)field);
        Type columnType = Type.get((String)column.getType());
        return Type.NUMERIC.isAssignableFrom(columnType);
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.VALUES_COLUMN);
    }
}

