/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.math;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.daikon.number.BigDecimalFormatter;
import org.talend.daikon.number.BigDecimalParser;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.parameters.ParameterType;
import org.talend.dataprep.parameters.SelectParameter;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#change_number_format")
public class ChangeNumberFormat
extends AbstractActionMetadata
implements ColumnAction {
    public static final String ACTION_NAME = "change_number_format";
    public static final String FROM_SEPARATORS = "from_separators";
    public static final String TARGET_PATTERN = "target_pattern";
    public static final String CUSTOM = "custom";
    public static final String US_SEPARATORS = "us_separators";
    public static final String EU_SEPARATORS = "eu_separators";
    public static final String CH_SEPARATORS = "ch_separators";
    public static final String US_PATTERN = "us_pattern";
    public static final String EU_PATTERN = "eu_pattern";
    public static final String CH_PATTERN = "ch_pattern";
    public static final String SCIENTIFIC = "scientific";
    public static final String FROM = "from";
    public static final String TARGET = "target";
    public static final String GROUPING = "_grouping";
    public static final String DECIMAL = "_decimal";
    public static final String SEPARATOR = "_separator";
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeNumberFormat.class);
    private static final String COMPILED_TARGET_FORMAT = "compiled_number_format";
    private static final String UNKNOWN_SEPARATORS = "unknown_separators";
    private static final DecimalFormat CH_DECIMAL_PATTERN = new DecimalFormat("#,##0.##", DecimalFormatSymbols.getInstance(new Locale("FR", "CH")));

    @Override
    public String getName() {
        return ACTION_NAME;
    }

    @Override
    public String getCategory() {
        return ActionCategory.NUMBERS.getDisplayName();
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        ColumnMetadata column = RowMetadataUtils.toColumnMetadata((Schema.Field)field);
        Type columnType = Type.get((String)column.getType());
        return Type.NUMERIC.isAssignableFrom(columnType);
    }

    @Override
    public List<Parameter> getParameters() {
        List<Parameter> parameters = super.getParameters();
        parameters.add((Parameter)SelectParameter.Builder.builder().name(FROM_SEPARATORS).item(UNKNOWN_SEPARATORS).item(US_SEPARATORS).item(EU_SEPARATORS).item(CH_SEPARATORS).item(CUSTOM, new Parameter[]{this.buildDecimalSeparatorParameter(FROM), this.buildGroupingSeparatorParameter(FROM)}).defaultValue(UNKNOWN_SEPARATORS).build());
        parameters.add((Parameter)SelectParameter.Builder.builder().name(TARGET_PATTERN).item(US_PATTERN).item(EU_PATTERN).item(CH_PATTERN).item(SCIENTIFIC).item(CUSTOM, new Parameter[]{new Parameter("target_pattern_custom", ParameterType.STRING, BigDecimalParser.US_DECIMAL_PATTERN.toPattern()), this.buildDecimalSeparatorParameter(TARGET), this.buildGroupingSeparatorParameter(TARGET)}).defaultValue(US_PATTERN).build());
        return parameters;
    }

    private Parameter buildDecimalSeparatorParameter(String prefix) {
        String name = prefix + DECIMAL + SEPARATOR;
        return SelectParameter.Builder.builder().name(name).item(".").item(",").item(CUSTOM, new Parameter[]{new Parameter(name + "_" + CUSTOM, ParameterType.STRING, ".")}).defaultValue(".").build();
    }

    private Parameter buildGroupingSeparatorParameter(String prefix) {
        String name = prefix + GROUPING + SEPARATOR;
        return SelectParameter.Builder.builder().name(name).item(",", ", (comma)").item(" ", " (space)").item(".", ". (dot)").item("'", "' (quote)").item("", "None").item(CUSTOM, new Parameter[]{new Parameter(name + "_" + CUSTOM, ParameterType.STRING, ",")}).canBeBlank(true).defaultValue(",").build();
    }

    private String getCustomizableParam(String pName, Map<String, String> parameters) {
        if (!parameters.containsKey(pName)) {
            return "";
        }
        if (parameters.get(pName).equals(CUSTOM)) {
            return parameters.get(pName + "_" + CUSTOM);
        }
        return parameters.get(pName);
    }

    private NumberFormat getFormat(Map<String, String> parameters) {
        switch (parameters.get(TARGET_PATTERN)) {
            case "custom": {
                return this.getCustomFormat(parameters);
            }
            case "us_pattern": {
                return BigDecimalParser.US_DECIMAL_PATTERN;
            }
            case "eu_pattern": {
                return BigDecimalParser.EU_DECIMAL_PATTERN;
            }
            case "ch_pattern": {
                return CH_DECIMAL_PATTERN;
            }
            case "scientific": {
                return BigDecimalParser.US_SCIENTIFIC_DECIMAL_PATTERN;
            }
        }
        throw new IllegalArgumentException("Pattern is empty");
    }

    private NumberFormat getCustomFormat(Map<String, String> parameters) {
        String groupingSeparator;
        DecimalFormat decimalFormat = new DecimalFormat(parameters.get("target_pattern_custom"));
        DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
        String decimalSeparator = this.getCustomizableParam("target_decimal_separator", parameters);
        if (!StringUtils.isEmpty((String)decimalSeparator)) {
            decimalFormatSymbols.setDecimalSeparator(decimalSeparator.charAt(0));
        }
        if (StringUtils.isEmpty((String)(groupingSeparator = this.getCustomizableParam("target_grouping_separator", parameters))) || groupingSeparator.equals(decimalSeparator)) {
            decimalFormat.setGroupingUsed(false);
        } else {
            decimalFormatSymbols.setGroupingSeparator(groupingSeparator.charAt(0));
        }
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        return decimalFormat;
    }

    @Override
    public void compile(ActionContext actionContext) {
        super.compile(actionContext);
        if (actionContext.getActionStatus() == ActionContext.ActionStatus.OK) {
            try {
                actionContext.get(COMPILED_TARGET_FORMAT, p -> this.getFormat(actionContext.getParameters()));
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Unsupported number format", (Throwable)e);
                actionContext.setActionStatus(ActionContext.ActionStatus.CANCELED);
            }
        }
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        String columnId = context.getColumnId();
        DecimalFormat decimalTargetFormat = (DecimalFormat)context.get(COMPILED_TARGET_FORMAT);
        ColumnMetadata columnMetadata = context.getRowMetadata().getById(columnId);
        columnMetadata.setType(Type.DOUBLE.toString());
        columnMetadata.setTypeForced(true);
        columnMetadata.setDomain("");
        columnMetadata.setDomainLabel("");
        columnMetadata.setDomainForced(true);
        String value = row.get(columnId);
        if (StringUtils.isBlank((String)value)) {
            LOGGER.debug("Unable to parse {} value as Number, it is blank", (Object)value);
            return;
        }
        try {
            BigDecimal bd;
            switch ((String)context.getParameters().get(FROM_SEPARATORS)) {
                case "eu_separators": {
                    bd = BigDecimalParser.toBigDecimal((String)value, (char)',', (char)'.');
                    break;
                }
                case "ch_separators": {
                    bd = BigDecimalParser.toBigDecimal((String)value, (char)'.', (char)'\'');
                    break;
                }
                case "custom": {
                    bd = this.parseCustomNumber(context, value);
                    break;
                }
                case "us_separators": {
                    bd = BigDecimalParser.toBigDecimal((String)value, (char)'.', (char)',');
                    break;
                }
                default: {
                    bd = BigDecimalParser.toBigDecimal((String)value);
                }
            }
            String newValue = BigDecimalFormatter.format((BigDecimal)bd, (DecimalFormat)decimalTargetFormat);
            row.set(columnId, newValue);
        }
        catch (NumberFormatException e) {
            LOGGER.debug("Unable to parse {} value as Number", (Object)value);
        }
    }

    private BigDecimal parseCustomNumber(ActionContext context, String number) {
        String decSep = this.getCustomizableParam("from_decimal_separator", context.getParameters());
        String groupSep = this.getCustomizableParam("from_grouping_separator", context.getParameters());
        if (StringUtils.isEmpty((String)decSep)) {
            decSep = ".";
        }
        if (StringUtils.isEmpty((String)groupSep)) {
            groupSep = ",";
        }
        BigDecimal bd = BigDecimalParser.toBigDecimal((String)number, (char)decSep.charAt(0), (char)groupSep.charAt(0));
        return bd;
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.VALUES_COLUMN);
    }
}

