/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.math;

import java.math.BigDecimal;
import java.util.EnumSet;
import java.util.Set;
import org.apache.avro.Schema;
import org.talend.daikon.number.BigDecimalParser;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.common.AbstractCompareAction;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.actions.common.CompareAction;
import org.talend.dataprep.transformation.actions.common.OtherColumnParameters;

@Action(value="action#compare_numbers")
public class CompareNumbers
extends AbstractCompareAction
implements ColumnAction,
OtherColumnParameters,
CompareAction {
    public static final String ACTION_NAME = "compare_numbers";

    @Override
    public String getName() {
        return ACTION_NAME;
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        ColumnMetadata column = RowMetadataUtils.toColumnMetadata((Schema.Field)field);
        Type columnType = Type.get((String)column.getType());
        return Type.NUMERIC.isAssignableFrom(columnType);
    }

    @Override
    public String getCategory() {
        return ActionCategory.NUMBERS.getDisplayName();
    }

    @Override
    protected int doCompare(AbstractCompareAction.ComparisonRequest comparisonRequest) {
        BigDecimal value = BigDecimalParser.toBigDecimal((String)comparisonRequest.value1);
        BigDecimal toCompare = BigDecimalParser.toBigDecimal((String)comparisonRequest.value2);
        return value.compareTo(toCompare);
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.METADATA_CREATE_COLUMNS);
    }
}

