/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.math;

import java.util.Map;
import org.apache.commons.math3.util.FastMath;
import org.talend.daikon.number.BigDecimalParser;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.transformation.actions.math.AbstractMathNoParameterAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#cos_numbers")
public class Cos
extends AbstractMathNoParameterAction {
    protected static final String COS_NAME = "cos_numbers";

    @Override
    protected String calculateResult(String columnValue, ActionContext context) {
        double value = BigDecimalParser.toBigDecimal((String)columnValue).doubleValue();
        double result = FastMath.cos((double)value);
        return Double.isNaN(result) ? "" : Double.toString(result);
    }

    @Override
    protected String getColumnNameSuffix(Map<String, String> parameters) {
        return "cos";
    }

    @Override
    public String getName() {
        return COS_NAME;
    }
}

