/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.math;

import java.math.BigDecimal;
import org.apache.avro.Schema;
import org.talend.daikon.number.BigDecimalParser;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.transformation.actions.delete.AbstractDelete;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#delete_negative_values")
public class DeleteNegativeValues
extends AbstractDelete {
    public static final String ACTION_NAME = "delete_negative_values";

    @Override
    public String getName() {
        return ACTION_NAME;
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        ColumnMetadata column = RowMetadataUtils.toColumnMetadata((Schema.Field)field);
        return Type.NUMERIC.isAssignableFrom(Type.get((String)column.getType()));
    }

    @Override
    public boolean toDelete(DataSetRow dataSetRow, String columnId, ActionContext context) {
        String value = dataSetRow.get(columnId);
        if (value == null) {
            return false;
        }
        try {
            BigDecimal bd = BigDecimalParser.toBigDecimal((String)value.trim());
            return bd.compareTo(BigDecimal.ZERO) < 0;
        }
        catch (NumberFormatException exc) {
            return false;
        }
    }
}

