/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.math;

import java.util.Map;
import org.apache.commons.math3.util.FastMath;
import org.talend.daikon.number.BigDecimalParser;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.transformation.actions.math.AbstractMathNoParameterAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#exponential_numbers")
public class Exponential
extends AbstractMathNoParameterAction {
    protected static final String EXPONENTIAL_NAME = "exponential_numbers";

    @Override
    protected String calculateResult(String columnValue, ActionContext context) {
        double value = BigDecimalParser.toBigDecimal((String)columnValue).doubleValue();
        return Double.toString(FastMath.exp((double)value));
    }

    @Override
    protected String getColumnNameSuffix(Map<String, String> parameters) {
        return "exponential";
    }

    @Override
    public String getName() {
        return EXPONENTIAL_NAME;
    }
}

