/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.math;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.StringCharacterIterator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.avro.Schema;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.talend.daikon.number.BigDecimalParser;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#extract_number")
public class ExtractNumber
extends AbstractActionMetadata
implements ColumnAction {
    public static final String EXTRACT_NUMBER_ACTION_NAME = "extract_number";
    private static final String DEFAULT_RESULT = "0";
    private static final int MAX_FRACTION_DIGITS_DISPLAY = 30;
    private static final List<Character> SEPARATORS = Arrays.asList(Character.valueOf('.'), Character.valueOf(','));
    private static Map<String, MetricPrefix> METRICPREFIXES = new ConcurrentHashMap<String, MetricPrefix>(13);

    private static String extractNumber(String value) {
        return ExtractNumber.extractNumber(value, DEFAULT_RESULT);
    }

    protected static String extractNumber(String value, String defaultValue) {
        if (StringUtils.isEmpty((String)value)) {
            return defaultValue;
        }
        try {
            return String.valueOf(BigDecimalParser.toBigDecimal((String)value));
        }
        catch (NumberFormatException numberFormatException) {
            BigDecimal bigDecimal;
            StringCharacterIterator iter = new StringCharacterIterator(value);
            MetricPrefix metricPrefixBefore = null;
            MetricPrefix metricPrefixAfter = null;
            boolean numberFound = false;
            StringBuilder reducedValue = new StringBuilder(value.length());
            char c = iter.first();
            while (c != '\uffff') {
                if (NumberUtils.isNumber((String)String.valueOf(c)) || SEPARATORS.contains(Character.valueOf(c))) {
                    reducedValue.append(c);
                    numberFound = true;
                } else {
                    MetricPrefix found;
                    if (metricPrefixBefore == null && (found = METRICPREFIXES.get(String.valueOf(c))) != null && !numberFound) {
                        metricPrefixBefore = found;
                    }
                    if (metricPrefixAfter == null && (found = METRICPREFIXES.get(String.valueOf(c))) != null && numberFound) {
                        metricPrefixAfter = found;
                    }
                }
                c = iter.next();
            }
            try {
                bigDecimal = BigDecimalParser.toBigDecimal((String)reducedValue.toString());
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
            if (metricPrefixBefore != null || metricPrefixAfter != null) {
                MetricPrefix metricPrefix = metricPrefixAfter != null ? metricPrefixAfter : metricPrefixBefore;
                bigDecimal = bigDecimal.multiply(metricPrefix.getMultiply());
            }
            DecimalFormat decimalFormat = new DecimalFormat("0.#");
            decimalFormat.setMaximumFractionDigits(30);
            return decimalFormat.format(bigDecimal.stripTrailingZeros());
        }
    }

    @Override
    public String getName() {
        return EXTRACT_NUMBER_ACTION_NAME;
    }

    @Override
    public String getCategory() {
        return ActionCategory.SPLIT.getDisplayName();
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        return true;
    }

    @Override
    public void compile(ActionContext context) {
        super.compile(context);
        if (context.getActionStatus() == ActionContext.ActionStatus.OK) {
            String columnId = context.getColumnId();
            RowMetadata rowMetadata = context.getRowMetadata();
            ColumnMetadata column = rowMetadata.getById(columnId);
            context.column("result", r -> {
                ColumnMetadata c = ColumnMetadata.Builder.column().name(column.getName() + "_number").type(Type.STRING).build();
                rowMetadata.insertAfter(columnId, c);
                return c;
            });
        }
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        String columnId = context.getColumnId();
        String newColumnId = context.column("result");
        row.set(newColumnId, ExtractNumber.extractNumber(row.get(columnId)));
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return Collections.singleton(ActionDefinition.Behavior.METADATA_CREATE_COLUMNS);
    }

    static {
        METRICPREFIXES.put("T", new MetricPrefix(new BigDecimal("1000000000000"), "tera"));
        METRICPREFIXES.put("G", new MetricPrefix(new BigDecimal("1000000000"), "giga"));
        METRICPREFIXES.put("M", new MetricPrefix(new BigDecimal("1000000"), "mega"));
        METRICPREFIXES.put("k", new MetricPrefix(new BigDecimal("1000"), "kilo"));
        METRICPREFIXES.put("h", new MetricPrefix(new BigDecimal("100"), "hecto"));
        METRICPREFIXES.put("da", new MetricPrefix(new BigDecimal("10"), "deca"));
        METRICPREFIXES.put("d", new MetricPrefix(new BigDecimal("0.1"), "deci"));
        METRICPREFIXES.put("c", new MetricPrefix(new BigDecimal("0.01"), "centi"));
        METRICPREFIXES.put("m", new MetricPrefix(new BigDecimal("0.001"), "milli"));
        METRICPREFIXES.put("\u03bc", new MetricPrefix(new BigDecimal("0.000001"), "micro"));
        METRICPREFIXES.put("n", new MetricPrefix(new BigDecimal("0.000000001"), "nano"));
        METRICPREFIXES.put("p", new MetricPrefix(new BigDecimal("0.000000000001"), "pico"));
    }

    private static class MetricPrefix {
        private final String name;
        private final BigDecimal multiply;

        MetricPrefix(BigDecimal multiply, String name) {
            this.multiply = multiply;
            this.name = name;
        }

        BigDecimal getMultiply() {
            return this.multiply;
        }

        public String getName() {
            return this.name;
        }
    }
}

