/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.math;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.math3.util.FastMath;
import org.talend.daikon.number.BigDecimalParser;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.transformation.actions.math.AbstractMathOneParameterAction;

@Action(value="action#max_numbers")
public class Max
extends AbstractMathOneParameterAction {
    protected static final String MAX_NAME = "max_numbers";

    @Override
    public String getName() {
        return MAX_NAME;
    }

    @Override
    protected String getColumnNameSuffix(Map<String, String> parameters) {
        return "max";
    }

    @Override
    protected String calculateResult(String columnValue, String parameter) {
        String max = Double.toString(BigDecimalParser.toBigDecimal((String)columnValue).doubleValue());
        if (StringUtils.isNotBlank((String)parameter)) {
            max = Double.toString(FastMath.max((double)BigDecimalParser.toBigDecimal((String)columnValue).doubleValue(), (double)BigDecimalParser.toBigDecimal((String)parameter).doubleValue()));
        }
        return max;
    }
}

