/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.math;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.math3.util.FastMath;
import org.talend.daikon.number.BigDecimalParser;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.transformation.actions.math.AbstractMathOneParameterAction;

@Action(value="action#min_numbers")
public class Min
extends AbstractMathOneParameterAction {
    protected static final String MIN_NAME = "min_numbers";

    @Override
    public String getName() {
        return MIN_NAME;
    }

    @Override
    protected String getColumnNameSuffix(Map<String, String> parameters) {
        return "min";
    }

    @Override
    protected String calculateResult(String columnValue, String parameter) {
        String min = Double.toString(BigDecimalParser.toBigDecimal((String)columnValue).doubleValue());
        if (StringUtils.isNotBlank((String)parameter)) {
            min = Double.toString(FastMath.min((double)BigDecimalParser.toBigDecimal((String)columnValue).doubleValue(), (double)BigDecimalParser.toBigDecimal((String)parameter).doubleValue()));
        }
        return min;
    }
}

