/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.math;

import java.util.Map;
import org.apache.commons.math3.util.FastMath;
import org.talend.daikon.number.BigDecimalParser;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.transformation.actions.math.AbstractMathNoParameterAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#natural_logarithm_numbers")
public class NaturalLogarithm
extends AbstractMathNoParameterAction {
    protected static final String NATURAL_LOGARITHM_NAME = "natural_logarithm_numbers";

    @Override
    protected String calculateResult(String columnValue, ActionContext context) {
        double value = BigDecimalParser.toBigDecimal((String)columnValue).doubleValue();
        double result = FastMath.log((double)value);
        return Double.isNaN(result) ? "" : Double.toString(result);
    }

    @Override
    protected String getColumnNameSuffix(Map<String, String> parameters) {
        return "natural_logarithm";
    }

    @Override
    public String getName() {
        return NATURAL_LOGARITHM_NAME;
    }
}

