/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.math;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.talend.daikon.exception.ExceptionContext;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.exception.error.ErrorCode;
import org.talend.daikon.number.BigDecimalParser;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.exception.error.ActionErrorCodes;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.parameters.ParameterType;
import org.talend.dataprep.parameters.SelectParameter;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.actions.common.OtherColumnParameters;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#numeric_ops")
public class NumericOperations
extends AbstractActionMetadata
implements ColumnAction,
OtherColumnParameters {
    public static final String ACTION_NAME = "numeric_ops";
    public static final String MODE_PARAMETER = "mode";
    public static final String OPERATOR_PARAMETER = "operator";
    public static final String OPERAND_PARAMETER = "operand";
    private static final String PLUS = "+";
    private static final String MINUS = "-";
    private static final String MULTIPLY = "x";
    private static final String DIVIDE = "/";

    @Override
    public String getName() {
        return ACTION_NAME;
    }

    @Override
    public String getCategory() {
        return ActionCategory.MATH.getDisplayName();
    }

    @Override
    public List<Parameter> getParameters() {
        List<Parameter> parameters = super.getParameters();
        parameters.add((Parameter)SelectParameter.Builder.builder().name(OPERATOR_PARAMETER).item(PLUS).item(MULTIPLY).item(MINUS).item(DIVIDE).defaultValue(MULTIPLY).build());
        parameters.add((Parameter)SelectParameter.Builder.builder().name(MODE_PARAMETER).item("constant_mode", new Parameter[]{new Parameter(OPERAND_PARAMETER, ParameterType.STRING, "2")}).item("other_column_mode", new Parameter[]{new Parameter("selected_column", ParameterType.COLUMN, "", false, false, "")}).defaultValue("constant_mode").build());
        return parameters;
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        ColumnMetadata column = RowMetadataUtils.toColumnMetadata((Schema.Field)field);
        Type columnType = Type.get((String)column.getType());
        return Type.NUMERIC.isAssignableFrom(columnType);
    }

    @Override
    public void compile(ActionContext context) {
        super.compile(context);
        if (context.getActionStatus() == ActionContext.ActionStatus.OK) {
            String operandName;
            this.checkParameters(context.getParameters(), context.getRowMetadata());
            Map parameters = context.getParameters();
            String columnId = context.getColumnId();
            RowMetadata rowMetadata = context.getRowMetadata();
            ColumnMetadata sourceColumn = rowMetadata.getById(columnId);
            String operator = (String)parameters.get(OPERATOR_PARAMETER);
            if (((String)parameters.get(MODE_PARAMETER)).equals("constant_mode")) {
                operandName = (String)parameters.get(OPERAND_PARAMETER);
            } else {
                ColumnMetadata selectedColumn = rowMetadata.getById((String)parameters.get("selected_column"));
                operandName = selectedColumn.getName();
            }
            context.column("result", r -> {
                ColumnMetadata c = ColumnMetadata.Builder.column().name(sourceColumn.getName() + " " + operator + " " + operandName).type(Type.DOUBLE).build();
                rowMetadata.insertAfter(columnId, c);
                return c;
            });
        }
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        String operand;
        Map parameters = context.getParameters();
        String columnId = context.getColumnId();
        RowMetadata rowMetadata = context.getRowMetadata();
        String operator = (String)parameters.get(OPERATOR_PARAMETER);
        if (((String)parameters.get(MODE_PARAMETER)).equals("constant_mode")) {
            operand = (String)parameters.get(OPERAND_PARAMETER);
        } else {
            ColumnMetadata selectedColumn = rowMetadata.getById((String)parameters.get("selected_column"));
            operand = row.get(selectedColumn.getId());
        }
        String newColumnId = context.column("result");
        String sourceValue = row.get(columnId);
        String newValue = this.compute(sourceValue, operator, operand);
        row.set(newColumnId, newValue);
    }

    protected String compute(String stringOperandOne, String operator, String stringOperandTwo) {
        try {
            BigDecimal toReturn;
            BigDecimal operandOne = BigDecimalParser.toBigDecimal((String)stringOperandOne);
            BigDecimal operandTwo = BigDecimalParser.toBigDecimal((String)stringOperandTwo);
            int scale = 2;
            RoundingMode rm = RoundingMode.HALF_UP;
            switch (operator) {
                case "+": {
                    toReturn = operandOne.add(operandTwo);
                    break;
                }
                case "x": {
                    toReturn = operandOne.multiply(operandTwo);
                    break;
                }
                case "-": {
                    toReturn = operandOne.subtract(operandTwo);
                    break;
                }
                case "/": {
                    toReturn = operandOne.divide(operandTwo, 2, rm);
                    break;
                }
                default: {
                    return "";
                }
            }
            return toReturn.setScale(2, rm).stripTrailingZeros().toPlainString();
        }
        catch (ArithmeticException | NullPointerException | NumberFormatException e) {
            return "";
        }
    }

    private void checkParameters(Map<String, String> parameters, RowMetadata rowMetadata) {
        if (parameters.get(MODE_PARAMETER).equals("constant_mode") && !parameters.containsKey(OPERAND_PARAMETER)) {
            throw new TalendRuntimeException((ErrorCode)ActionErrorCodes.BAD_ACTION_PARAMETER, ExceptionContext.build().put("paramName", (Object)OPERAND_PARAMETER));
        }
        if (!(parameters.get(MODE_PARAMETER).equals("constant_mode") || parameters.containsKey("selected_column") && rowMetadata.getById(parameters.get("selected_column")) != null)) {
            throw new TalendRuntimeException((ErrorCode)ActionErrorCodes.BAD_ACTION_PARAMETER, ExceptionContext.build().put("paramName", (Object)"selected_column"));
        }
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.METADATA_CREATE_COLUMNS);
    }
}

