/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.math;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.math3.util.FastMath;
import org.talend.daikon.number.BigDecimalParser;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.transformation.actions.math.AbstractMathOneParameterAction;

@Action(value="action#pow_numbers")
public class Pow
extends AbstractMathOneParameterAction {
    protected static final String POW_NAME = "pow_numbers";

    @Override
    public String getName() {
        return POW_NAME;
    }

    @Override
    protected String getColumnNameSuffix(Map<String, String> parameters) {
        return "pow";
    }

    @Override
    protected String calculateResult(String columnValue, String parameter) {
        String pow = Double.toString(BigDecimalParser.toBigDecimal((String)columnValue).doubleValue());
        if (StringUtils.isNotBlank((String)parameter)) {
            pow = Double.toString(FastMath.pow((double)BigDecimalParser.toBigDecimal((String)columnValue).doubleValue(), (double)BigDecimalParser.toBigDecimal((String)parameter).doubleValue()));
        }
        return pow;
    }
}

