/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.math;

import java.util.Map;
import org.apache.commons.math3.util.FastMath;
import org.talend.daikon.number.BigDecimalParser;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.transformation.actions.math.AbstractMathNoParameterAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#sin_numbers")
public class Sin
extends AbstractMathNoParameterAction {
    protected static final String SIN_NAME = "sin_numbers";

    @Override
    protected String calculateResult(String columnValue, ActionContext context) {
        double value = BigDecimalParser.toBigDecimal((String)columnValue).doubleValue();
        double result = FastMath.sin((double)value);
        return Double.isNaN(result) ? "" : Double.toString(result);
    }

    @Override
    protected String getColumnNameSuffix(Map<String, String> parameters) {
        return "sin";
    }

    @Override
    public String getName() {
        return SIN_NAME;
    }
}

