/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.math;

import java.util.Map;
import org.apache.commons.math3.util.FastMath;
import org.talend.daikon.number.BigDecimalParser;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.transformation.actions.math.AbstractMathNoParameterAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#square_root_numbers")
public class SquareRoot
extends AbstractMathNoParameterAction {
    protected static final String SQRT_NAME = "square_root_numbers";

    @Override
    protected String calculateResult(String columnValue, ActionContext context) {
        double value = BigDecimalParser.toBigDecimal((String)columnValue).doubleValue();
        return value < 0.0 ? "" : Double.toString(FastMath.sqrt((double)value));
    }

    @Override
    protected String getColumnNameSuffix(Map<String, String> parameters) {
        return "square_root";
    }

    @Override
    public String getName() {
        return SQRT_NAME;
    }
}

