/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.math;

import java.util.Map;
import org.apache.commons.math3.util.FastMath;
import org.talend.daikon.number.BigDecimalParser;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.transformation.actions.math.AbstractMathNoParameterAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#tan_numbers")
public class Tan
extends AbstractMathNoParameterAction {
    protected static final String TAN_NAME = "tan_numbers";

    @Override
    protected String calculateResult(String columnValue, ActionContext context) {
        double value = BigDecimalParser.toBigDecimal((String)columnValue).doubleValue();
        double result = FastMath.tan((double)value);
        return Double.isNaN(result) ? "" : Double.toString(result);
    }

    @Override
    protected String getColumnNameSuffix(Map<String, String> parameters) {
        return "tan";
    }

    @Override
    public String getName() {
        return TAN_NAME;
    }
}

