/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.math;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import javax.measure.quantity.Temperature;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.apache.commons.lang3.math.NumberUtils;
import org.talend.daikon.number.BigDecimalParser;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.parameters.ParameterType;
import org.talend.dataprep.parameters.SelectParameter;
import org.talend.dataprep.transformation.actions.math.AbstractMathNoParameterAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;
import org.talend.dataprep.units.TemperatureImpl;

@Action(value="action#temperatures_converter")
public class TemperaturesConverter
extends AbstractMathNoParameterAction {
    public static final String ACTION_NAME = "temperatures_converter";
    private static final String FROM_UNIT_PARAMETER = "from_temperature";
    private static final String TO_UNIT_PARAMETER = "to_temperature";
    private static final String TARGET_PRECISION = "precision";

    @Override
    protected String calculateResult(String columnValue, ActionContext context) {
        TemperatureUnit fromTemperatureUnit = TemperatureUnit.valueOf((String)context.getParameters().get(FROM_UNIT_PARAMETER));
        TemperatureUnit toTemperatureUnit = TemperatureUnit.valueOf((String)context.getParameters().get(TO_UNIT_PARAMETER));
        String precisionParameter = (String)context.getParameters().get(TARGET_PRECISION);
        BigDecimal value = BigDecimalParser.toBigDecimal((String)columnValue);
        TemperatureImpl fromTemp = new TemperatureImpl(value, fromTemperatureUnit.asJavaUnit());
        TemperatureImpl temperature = fromTemp.convertTo(toTemperatureUnit.asJavaUnit());
        Integer targetScale = NumberUtils.toInt((String)precisionParameter, (int)value.scale());
        return temperature.getValue().setScale((int)targetScale, RoundingMode.HALF_UP).toPlainString();
    }

    @Override
    public List<Parameter> getParameters() {
        List<Parameter> parameters = super.getParameters();
        parameters.add((Parameter)SelectParameter.Builder.builder().item(TemperatureUnit.FAHRENHEIT.name(), TemperatureUnit.FAHRENHEIT.toString()).item(TemperatureUnit.CELSIUS.name(), TemperatureUnit.CELSIUS.toString()).item(TemperatureUnit.KELVIN.name(), TemperatureUnit.KELVIN.toString()).canBeBlank(false).defaultValue(TemperatureUnit.FAHRENHEIT.name()).name(FROM_UNIT_PARAMETER).build());
        parameters.add((Parameter)SelectParameter.Builder.builder().item(TemperatureUnit.FAHRENHEIT.name(), TemperatureUnit.FAHRENHEIT.toString()).item(TemperatureUnit.CELSIUS.name(), TemperatureUnit.CELSIUS.toString()).item(TemperatureUnit.KELVIN.name(), TemperatureUnit.KELVIN.toString()).canBeBlank(false).defaultValue(TemperatureUnit.CELSIUS.name()).name(TO_UNIT_PARAMETER).build());
        parameters.add(new Parameter(TARGET_PRECISION, ParameterType.INTEGER, null, false, true, TARGET_PRECISION));
        return parameters;
    }

    @Override
    public String getName() {
        return ACTION_NAME;
    }

    @Override
    public String getCategory() {
        return "Conversions";
    }

    @Override
    protected String getColumnNameSuffix(Map<String, String> parameters) {
        String name = parameters.get(TO_UNIT_PARAMETER);
        TemperatureUnit temperatureUnit = TemperatureUnit.valueOf(name);
        return "in " + temperatureUnit.toString();
    }

    public static enum TemperatureUnit {
        FAHRENHEIT("Fahrenheit", (Unit<Temperature>)NonSI.FAHRENHEIT),
        CELSIUS("Celsius", (Unit<Temperature>)SI.CELSIUS),
        KELVIN("Kelvin", (Unit<Temperature>)SI.KELVIN);

        private final String displayName;
        private final Unit<Temperature> javaUnit;

        private TemperatureUnit(String displayName, Unit<Temperature> javaUnit) {
            this.displayName = displayName;
            this.javaUnit = javaUnit;
        }

        public String toString() {
            return this.displayName;
        }

        public Unit<Temperature> asJavaUnit() {
            return this.javaUnit;
        }
    }
}

