/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.net;

import java.util.EnumSet;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.commons.lang.StringUtils;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#extractemaildomain")
public class ExtractEmailDomain
extends AbstractActionMetadata
implements ColumnAction {
    public static final String EXTRACT_DOMAIN_ACTION_NAME = "extractemaildomain";
    private static final String LOCAL = "_local";
    private static final String DOMAIN = "_domain";

    @Override
    public String getName() {
        return EXTRACT_DOMAIN_ACTION_NAME;
    }

    @Override
    public String getCategory() {
        return ActionCategory.SPLIT.getDisplayName();
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        ColumnMetadata column = RowMetadataUtils.toColumnMetadata((Schema.Field)field);
        return Type.STRING.equals((Object)Type.get((String)column.getType())) && StringUtils.equalsIgnoreCase((String)"email", (String)column.getDomain());
    }

    @Override
    public void compile(ActionContext context) {
        super.compile(context);
        if (context.getActionStatus() == ActionContext.ActionStatus.OK) {
            String columnId = context.getColumnId();
            RowMetadata rowMetadata = context.getRowMetadata();
            ColumnMetadata column = rowMetadata.getById(columnId);
            String local = context.column(LOCAL, r -> {
                ColumnMetadata newColumn = ColumnMetadata.Builder.column().name(column.getName() + LOCAL).type(Type.STRING).build();
                rowMetadata.insertAfter(columnId, newColumn);
                return newColumn;
            });
            context.column(DOMAIN, r -> {
                ColumnMetadata newColumn = ColumnMetadata.Builder.column().name(column.getName() + DOMAIN).type(Type.STRING).build();
                rowMetadata.insertAfter(local, newColumn);
                return newColumn;
            });
        }
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        String columnId = context.getColumnId();
        String originalValue = row.get(columnId);
        String local = context.column(LOCAL);
        String domain = context.column(DOMAIN);
        if (originalValue == null) {
            return;
        }
        String[] split = originalValue.split("@", 2);
        String localPart = split.length >= 2 ? split[0] : "";
        row.set(local, localPart);
        String domainPart = split.length >= 2 ? split[1] : "";
        row.set(domain, domainPart);
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.METADATA_CREATE_COLUMNS);
    }
}

