/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.net;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.actions.net.UrlTokenExtractor;
import org.talend.dataprep.transformation.actions.net.UrlTokenExtractors;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#extract_url_tokens")
public class ExtractUrlTokens
extends AbstractActionMetadata
implements ColumnAction {
    public static final String EXTRACT_URL_TOKENS_ACTION_NAME = "extract_url_tokens";
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtractUrlTokens.class);

    @Override
    public String getName() {
        return EXTRACT_URL_TOKENS_ACTION_NAME;
    }

    @Override
    public String getCategory() {
        return ActionCategory.SPLIT.getDisplayName();
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        ColumnMetadata column = RowMetadataUtils.toColumnMetadata((Schema.Field)field);
        return Type.STRING.equals((Object)Type.get((String)column.getType())) && StringUtils.equalsIgnoreCase((String)"url", (String)column.getDomain());
    }

    @Override
    public void compile(ActionContext context) {
        super.compile(context);
        if (context.getActionStatus() == ActionContext.ActionStatus.OK) {
            String columnId = context.getColumnId();
            RowMetadata rowMetadata = context.getRowMetadata();
            ColumnMetadata column = rowMetadata.getById(columnId);
            String lastId = column.getId();
            for (UrlTokenExtractor urlTokenExtractor : UrlTokenExtractors.urlTokenExtractors) {
                String columnName = column.getName() + urlTokenExtractor.getTokenName();
                String columnToInsertAfter = lastId;
                lastId = context.column(columnName, r -> {
                    ColumnMetadata newColumn = ColumnMetadata.Builder.column().name(columnName).type(urlTokenExtractor.getType()).build();
                    rowMetadata.insertAfter(columnToInsertAfter, newColumn);
                    return newColumn;
                });
            }
        }
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        String columnId = context.getColumnId();
        String originalValue = row.get(columnId);
        RowMetadata rowMetadata = context.getRowMetadata();
        ColumnMetadata column = rowMetadata.getById(columnId);
        URI url = null;
        try {
            url = new URI(originalValue);
        }
        catch (NullPointerException | URISyntaxException e) {
            LOGGER.debug("Unable to parse value {}.", (Object)originalValue, (Object)e);
        }
        for (UrlTokenExtractor urlTokenExtractor : UrlTokenExtractors.urlTokenExtractors) {
            String columnName = column.getName() + urlTokenExtractor.getTokenName();
            String id = context.column(columnName);
            String tokenValue = url == null ? "" : urlTokenExtractor.extractToken(url);
            row.set(id, tokenValue == null ? "" : tokenValue);
        }
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.METADATA_CREATE_COLUMNS);
    }
}

