/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.net;

import java.net.URI;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.transformation.actions.net.UrlTokenExtractor;

public class UrlTokenExtractors {
    protected static final UrlTokenExtractor PROTOCOL_TOKEN_EXTRACTOR = new UrlTokenExtractor(){

        @Override
        public String getTokenName() {
            return "_protocol";
        }

        @Override
        public String extractToken(URI url) {
            String scheme = url.getScheme();
            return scheme == null ? "" : scheme.toLowerCase();
        }
    };
    protected static final UrlTokenExtractor HOST_TOKEN_EXTRACTOR = new UrlTokenExtractor(){

        @Override
        public String getTokenName() {
            return "_host";
        }

        @Override
        public String extractToken(URI url) {
            return url.getHost();
        }
    };
    protected static final UrlTokenExtractor PORT_TOKEN_EXTRACTOR = new UrlTokenExtractor(){

        @Override
        public String getTokenName() {
            return "_port";
        }

        @Override
        public String extractToken(URI url) {
            int port = url.getPort();
            return port == -1 ? "" : port + "";
        }

        @Override
        public Type getType() {
            return Type.INTEGER;
        }
    };
    protected static final UrlTokenExtractor PATH_TOKEN_EXTRACTOR = new UrlTokenExtractor(){

        @Override
        public String getTokenName() {
            return "_path";
        }

        @Override
        public String extractToken(URI url) {
            return url.getPath();
        }
    };
    protected static final UrlTokenExtractor QUERY_TOKEN_EXTRACTOR = new UrlTokenExtractor(){

        @Override
        public String getTokenName() {
            return "_query";
        }

        @Override
        public String extractToken(URI url) {
            return url.getQuery();
        }
    };
    protected static final UrlTokenExtractor FRAGMENT_TOKEN_EXTRACTOR = new UrlTokenExtractor(){

        @Override
        public String getTokenName() {
            return "_fragment";
        }

        @Override
        public String extractToken(URI url) {
            return url.getFragment();
        }
    };
    protected static final UrlTokenExtractor USER_TOKEN_EXTRACTOR = new UrlTokenExtractor(){

        @Override
        public String getTokenName() {
            return "_user";
        }

        @Override
        public String extractToken(URI url) {
            String userInfo = url.getUserInfo();
            return userInfo == null ? "" : userInfo.split(":")[0];
        }
    };
    protected static final UrlTokenExtractor PASSWORD_TOKEN_EXTRACTOR = new UrlTokenExtractor(){

        @Override
        public String getTokenName() {
            return "_password";
        }

        @Override
        public String extractToken(URI url) {
            String userInfo = url.getUserInfo();
            return userInfo == null ? "" : userInfo.split(":")[1];
        }
    };
    protected static UrlTokenExtractor[] urlTokenExtractors = new UrlTokenExtractor[]{PROTOCOL_TOKEN_EXTRACTOR, HOST_TOKEN_EXTRACTOR, PORT_TOKEN_EXTRACTOR, PATH_TOKEN_EXTRACTOR, QUERY_TOKEN_EXTRACTOR, FRAGMENT_TOKEN_EXTRACTOR, USER_TOKEN_EXTRACTOR, PASSWORD_TOKEN_EXTRACTOR};
}

