/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.phonenumber;

import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.avro.Schema;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.parameters.ParameterType;
import org.talend.dataprep.parameters.SelectParameter;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;
import org.talend.dataquality.standardization.phone.PhoneNumberHandlerBase;

@Action(value="action#format_phone_number")
public class FormatPhoneNumber
extends AbstractActionMetadata
implements ColumnAction {
    public static final String ACTION_NAME = "format_phone_number";
    static final String REGIONS_PARAMETER_CONSTANT_MODE = "region_code";
    static final String MANUAL_REGION_PARAMETER_STRING = "manual_region_string";
    static final String FORMAT_TYPE_PARAMETER = "format_type";
    private static final String PHONE_NUMBER_HANDLER_KEY = "phone_number_handler_helper";
    private static final String US_REGION_CODE = "US";
    private static final String FR_REGION_CODE = "FR";
    private static final String UK_REGION_CODE = "UK";
    private static final String DE_REGION_CODE = "DE";
    static final String OTHER_REGION_TO_BE_SPECIFIED = "other (region)";
    private static final Logger LOGGER = LoggerFactory.getLogger(FormatPhoneNumber.class);
    static final String TYPE_INTERNATIONAL = "International";
    static final String TYPE_NATIONAL = "National";
    static final String TYPE_E164 = "E164";
    static final String TYPE_RFC3966 = "RFC3966";

    @Override
    public void compile(ActionContext context) {
        super.compile(context);
        if (context.getActionStatus() == ActionContext.ActionStatus.OK) {
            try {
                context.get(PHONE_NUMBER_HANDLER_KEY, p -> new PhoneNumberHandlerBase());
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                context.setActionStatus(ActionContext.ActionStatus.CANCELED);
            }
        }
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        String columnId = context.getColumnId();
        String possiblePhoneValue = row.get(columnId);
        if (StringUtils.isEmpty((String)possiblePhoneValue)) {
            return;
        }
        String regionCode = this.getRegionCode(context, row);
        String formatedStr = this.formatIfValid(regionCode, (PhoneNumberHandlerBase)context.get(PHONE_NUMBER_HANDLER_KEY), (String)context.getParameters().get(FORMAT_TYPE_PARAMETER), possiblePhoneValue);
        row.set(columnId, formatedStr);
    }

    private String formatIfValid(String regionParam, PhoneNumberHandlerBase phoneNumberHandler, String formatType, String phone) {
        if (formatType == null || !PhoneNumberHandlerBase.isPossiblePhoneNumber((Object)phone, (String)regionParam)) {
            return phone;
        }
        switch (formatType) {
            case "International": {
                return PhoneNumberHandlerBase.formatInternational((Object)phone, (String)regionParam);
            }
            case "National": {
                return PhoneNumberHandlerBase.formatNational((Object)phone, (String)regionParam);
            }
            case "E164": {
                return PhoneNumberHandlerBase.formatE164((Object)phone, (String)regionParam);
            }
            case "RFC3966": {
                return PhoneNumberHandlerBase.formatRFC396((Object)phone, (String)regionParam);
            }
        }
        return phone;
    }

    @Override
    @Nonnull
    public List<Parameter> getParameters() {
        List<Parameter> parameters = super.getParameters();
        parameters.add((Parameter)SelectParameter.Builder.builder().name("mode").item("other_column_mode", new Parameter[]{new Parameter("selected_column", ParameterType.COLUMN, "", false, false, "")}).item("constant_mode", new Parameter[]{SelectParameter.Builder.builder().name(REGIONS_PARAMETER_CONSTANT_MODE).canBeBlank(true).item(US_REGION_CODE).item(FR_REGION_CODE).item(UK_REGION_CODE).item(DE_REGION_CODE).item(OTHER_REGION_TO_BE_SPECIFIED, new Parameter[]{new Parameter(MANUAL_REGION_PARAMETER_STRING, ParameterType.STRING, "")}).defaultValue(US_REGION_CODE).build()}).defaultValue("constant_mode").build());
        parameters.add((Parameter)SelectParameter.Builder.builder().name(FORMAT_TYPE_PARAMETER).item(TYPE_INTERNATIONAL).item(TYPE_NATIONAL).item(TYPE_E164).item(TYPE_RFC3966).defaultValue(TYPE_INTERNATIONAL).build());
        return parameters;
    }

    private String getRegionCode(ActionContext context, DataSetRow row) {
        Map parameters = context.getParameters();
        String regionParam = null;
        switch ((String)parameters.get("mode")) {
            case "constant_mode": {
                regionParam = (String)parameters.get(REGIONS_PARAMETER_CONSTANT_MODE);
                if (!StringUtils.equals((String)OTHER_REGION_TO_BE_SPECIFIED, (String)regionParam)) break;
                regionParam = (String)parameters.get(MANUAL_REGION_PARAMETER_STRING);
                break;
            }
            case "other_column_mode": {
                ColumnMetadata selectedColumn = context.getRowMetadata().getById((String)parameters.get("selected_column"));
                regionParam = row.get(selectedColumn.getId());
                break;
            }
            default: {
                regionParam = Locale.getDefault().getCountry();
            }
        }
        return regionParam;
    }

    @Override
    public String getName() {
        return ACTION_NAME;
    }

    @Override
    public String getCategory() {
        return ActionCategory.PHONE_NUMBER.getDisplayName();
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        ColumnMetadata column = RowMetadataUtils.toColumnMetadata((Schema.Field)field);
        return Type.STRING.equals((Object)Type.get((String)column.getType())) || Type.INTEGER.equals((Object)Type.get((String)column.getType()));
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.VALUES_COLUMN);
    }
}

