/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.text;

import java.util.EnumSet;
import java.util.Set;
import org.apache.avro.Schema;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#compute_length")
public class ComputeLength
extends AbstractActionMetadata
implements ColumnAction {
    public static final String LENGTH_ACTION_NAME = "compute_length";
    public static final String APPENDIX = "_length";

    @Override
    public String getName() {
        return LENGTH_ACTION_NAME;
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        ColumnMetadata column = RowMetadataUtils.toColumnMetadata((Schema.Field)field);
        return Type.STRING.equals((Object)Type.get((String)column.getType()));
    }

    @Override
    public String getCategory() {
        return ActionCategory.STRINGS.getDisplayName();
    }

    @Override
    public void compile(ActionContext context) {
        super.compile(context);
        if (context.getActionStatus() == ActionContext.ActionStatus.OK) {
            RowMetadata rowMetadata = context.getRowMetadata();
            String columnId = context.getColumnId();
            ColumnMetadata column = rowMetadata.getById(columnId);
            context.column(column.getName() + APPENDIX, r -> {
                ColumnMetadata c = ColumnMetadata.Builder.column().name(column.getName() + APPENDIX).type(Type.INTEGER).empty(column.getQuality().getEmpty()).invalid(column.getQuality().getInvalid()).valid(column.getQuality().getValid()).headerSize(column.getHeaderSize()).build();
                rowMetadata.insertAfter(columnId, c);
                return c;
            });
        }
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        RowMetadata rowMetadata = context.getRowMetadata();
        String columnId = context.getColumnId();
        ColumnMetadata column = rowMetadata.getById(columnId);
        String lengthColumn = context.column(column.getName() + APPENDIX);
        String value = row.get(columnId);
        row.set(lengthColumn, value == null ? "0" : String.valueOf(value.length()));
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.METADATA_CREATE_COLUMNS);
    }
}

