/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.text;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.parameters.ParameterType;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.actions.common.ReplaceOnValueHelper;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#cut")
public class Cut
extends AbstractActionMetadata
implements ColumnAction {
    public static final String CUT_ACTION_NAME = "cut";
    public static final String PATTERN_PARAMETER = "pattern";
    public static final String REGEX_HELPER_KEY = "regex_helper";
    private ReplaceOnValueHelper regexParametersHelper = new ReplaceOnValueHelper();

    @Override
    public String getName() {
        return CUT_ACTION_NAME;
    }

    @Override
    public String getCategory() {
        return ActionCategory.STRINGS.getDisplayName();
    }

    @Override
    public List<Parameter> getParameters() {
        List<Parameter> parameters = super.getParameters();
        parameters.add(new Parameter(PATTERN_PARAMETER, ParameterType.REGEX, ""));
        return parameters;
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        ColumnMetadata column = RowMetadataUtils.toColumnMetadata((Schema.Field)field);
        return Type.STRING.equals((Object)Type.get((String)column.getType()));
    }

    @Override
    public void compile(ActionContext actionContext) {
        super.compile(actionContext);
        if (actionContext.getActionStatus() == ActionContext.ActionStatus.OK) {
            Map parameters = actionContext.getParameters();
            String rawParam = (String)parameters.get(PATTERN_PARAMETER);
            try {
                actionContext.get(REGEX_HELPER_KEY, p -> this.regexParametersHelper.build(rawParam, false));
            }
            catch (IllegalArgumentException e) {
                actionContext.setActionStatus(ActionContext.ActionStatus.CANCELED);
            }
        }
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        ReplaceOnValueHelper replaceOnValueParameter;
        String columnId = context.getColumnId();
        String toCut = row.get(columnId);
        if (toCut != null && (replaceOnValueParameter = (ReplaceOnValueHelper)context.get(REGEX_HELPER_KEY)).matches(toCut)) {
            if (replaceOnValueParameter.getOperator().equals("regex")) {
                String value = toCut.replaceAll(replaceOnValueParameter.getToken(), "");
                row.set(columnId, value);
            } else {
                String value = toCut.replace(replaceOnValueParameter.getToken(), "");
                row.set(columnId, value);
            }
        }
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.VALUES_COLUMN);
    }
}

