/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.text;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import org.apache.avro.Schema;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.parameters.ParameterType;
import org.talend.dataprep.parameters.SelectParameter;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#extract_string_tokens")
public class ExtractStringTokens
extends AbstractActionMetadata
implements ColumnAction {
    public static final String EXTRACT_STRING_TOKENS_ACTION_NAME = "extract_string_tokens";
    public static final String APPENDIX = "_part_";
    protected static final String MODE_PARAMETER = "extract_mode";
    protected static final String MULTIPLE_COLUMNS_MODE = "multiple_columns";
    protected static final String SINGLE_COLUMN_MODE = "single_column";
    protected static final String PARAMETER_REGEX = "regex";
    protected static final String LIMIT = "limit";
    protected static final String PARAMETER_SEPARATOR = "concat_separator";
    private static final String PATTERN = "pattern";
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtractStringTokens.class);

    @Override
    public String getName() {
        return EXTRACT_STRING_TOKENS_ACTION_NAME;
    }

    @Override
    public String getCategory() {
        return ActionCategory.SPLIT.getDisplayName();
    }

    @Override
    @Nonnull
    public List<Parameter> getParameters() {
        List<Parameter> parameters = super.getParameters();
        parameters.add(new Parameter(PARAMETER_REGEX, ParameterType.STRING, "#(\\w+)"));
        parameters.add((Parameter)SelectParameter.Builder.builder().name(MODE_PARAMETER).item(MULTIPLE_COLUMNS_MODE, new Parameter[]{new Parameter(LIMIT, ParameterType.INTEGER, "4")}).item(SINGLE_COLUMN_MODE, new Parameter[]{new Parameter(PARAMETER_SEPARATOR, ParameterType.STRING, ",")}).defaultValue(MULTIPLE_COLUMNS_MODE).build());
        return parameters;
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        ColumnMetadata column = RowMetadataUtils.toColumnMetadata((Schema.Field)field);
        return Type.STRING.equals((Object)Type.get((String)column.getType()));
    }

    @Override
    public void compile(ActionContext context) {
        super.compile(context);
        if (context.getActionStatus() == ActionContext.ActionStatus.OK) {
            String regex = (String)context.getParameters().get(PARAMETER_REGEX);
            if (StringUtils.isEmpty((String)regex)) {
                LOGGER.debug("Empty pattern, action canceled");
                context.setActionStatus(ActionContext.ActionStatus.CANCELED);
                return;
            }
            try {
                context.get(PATTERN, p -> Pattern.compile(regex));
            }
            catch (PatternSyntaxException e) {
                LOGGER.debug("Invalid pattern {} --> {}, action canceled", new Object[]{regex, e.getMessage(), e});
                context.setActionStatus(ActionContext.ActionStatus.CANCELED);
            }
            Map parameters = context.getParameters();
            String columnId = context.getColumnId();
            int limit = ((String)parameters.get(MODE_PARAMETER)).equals(MULTIPLE_COLUMNS_MODE) ? Integer.parseInt((String)parameters.get(LIMIT)) : 1;
            RowMetadata rowMetadata = context.getRowMetadata();
            ColumnMetadata column = rowMetadata.getById(columnId);
            ArrayList<String> newColumns = new ArrayList<String>();
            ArrayDeque<String> lastColumnId = new ArrayDeque<String>();
            lastColumnId.push(columnId);
            for (int i = 0; i < limit; ++i) {
                int newColumnIndex = i + 1;
                newColumns.add(context.column(column.getName() + APPENDIX + i, r -> {
                    ColumnMetadata c = ColumnMetadata.Builder.column().type(Type.STRING).computedId("").name(column.getName() + APPENDIX + newColumnIndex).build();
                    lastColumnId.push(rowMetadata.insertAfter((String)lastColumnId.pop(), c));
                    return c;
                }));
            }
        }
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        int i;
        Map parameters = context.getParameters();
        String columnId = context.getColumnId();
        int limit = ((String)parameters.get(MODE_PARAMETER)).equals(MULTIPLE_COLUMNS_MODE) ? Integer.parseInt((String)parameters.get(LIMIT)) : 1;
        RowMetadata rowMetadata = context.getRowMetadata();
        ColumnMetadata column = rowMetadata.getById(columnId);
        ArrayList<String> newColumns = new ArrayList<String>();
        for (int i2 = 0; i2 < limit; ++i2) {
            newColumns.add(context.column(column.getName() + APPENDIX + i2));
        }
        String originalValue = row.get(columnId);
        if (originalValue == null) {
            return;
        }
        Pattern pattern = (Pattern)context.get(PATTERN);
        Matcher matcher = pattern.matcher(originalValue);
        ArrayList<String> extractedValues = new ArrayList<String>();
        while (matcher.find()) {
            for (i = 1; i <= matcher.groupCount(); ++i) {
                String matchingValue = matcher.group(i);
                if (matchingValue == null) continue;
                extractedValues.add(matchingValue);
            }
        }
        if (((String)parameters.get(MODE_PARAMETER)).equals(MULTIPLE_COLUMNS_MODE)) {
            for (i = 0; i < newColumns.size(); ++i) {
                if (i < extractedValues.size()) {
                    row.set((String)newColumns.get(i), (String)extractedValues.get(i));
                    continue;
                }
                row.set((String)newColumns.get(i), "");
            }
        } else {
            StrBuilder strBuilder = new StrBuilder();
            strBuilder.appendWithSeparators(extractedValues, (String)parameters.get(PARAMETER_SEPARATOR));
            row.set((String)newColumns.get(0), strBuilder.toString());
        }
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.METADATA_CREATE_COLUMNS);
    }
}

