/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.text;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.parameters.ParameterType;
import org.talend.dataprep.parameters.SelectParameter;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#fuzzy_matching")
public class FuzzyMatching
extends AbstractActionMetadata
implements ColumnAction {
    public static final String ACTION_NAME = "fuzzy_matching";
    public static final String VALUE_PARAMETER = "reference_value";
    public static final String SENSITIVITY = "sensitivity";
    public static final String APPENDIX = "_matches";

    @Override
    public boolean acceptField(Schema.Field field) {
        ColumnMetadata column = RowMetadataUtils.toColumnMetadata((Schema.Field)field);
        return Type.STRING.equals((Object)Type.get((String)column.getType()));
    }

    @Override
    public String getCategory() {
        return ActionCategory.STRINGS.getDisplayName();
    }

    @Override
    public String getName() {
        return ACTION_NAME;
    }

    @Override
    public List<Parameter> getParameters() {
        List<Parameter> parameters = super.getParameters();
        parameters.add((Parameter)SelectParameter.Builder.builder().name("mode").item("constant_mode", new Parameter[]{new Parameter(VALUE_PARAMETER, ParameterType.STRING, "", false, true, "")}).item("other_column_mode", new Parameter[]{new Parameter("selected_column", ParameterType.COLUMN, "", false, false, "")}).defaultValue("constant_mode").build());
        parameters.add(new Parameter(SENSITIVITY, ParameterType.INTEGER, "1", false, false, ""));
        return parameters;
    }

    @Override
    public void compile(ActionContext context) {
        super.compile(context);
        if (context.getActionStatus() == ActionContext.ActionStatus.OK) {
            String columnId = context.getColumnId();
            RowMetadata rowMetadata = context.getRowMetadata();
            ColumnMetadata column = rowMetadata.getById(columnId);
            context.column(column.getName() + APPENDIX, r -> {
                ColumnMetadata c = ColumnMetadata.Builder.column().name(column.getName() + APPENDIX).type(Type.BOOLEAN).typeForce(true).empty(column.getQuality().getEmpty()).invalid(column.getQuality().getInvalid()).valid(column.getQuality().getValid()).headerSize(column.getHeaderSize()).build();
                rowMetadata.insertAfter(columnId, c);
                return c;
            });
        }
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        String referenceValue;
        String columnId = context.getColumnId();
        Map parameters = context.getParameters();
        int sensitivity = NumberUtils.toInt((String)((String)parameters.get(SENSITIVITY)));
        RowMetadata rowMetadata = context.getRowMetadata();
        ColumnMetadata column = rowMetadata.getById(columnId);
        String fuzzyMatches = context.column(column.getName() + APPENDIX);
        String value = row.get(context.getColumnId());
        if (((String)parameters.get("mode")).equals("constant_mode")) {
            referenceValue = (String)parameters.get(VALUE_PARAMETER);
        } else {
            ColumnMetadata selectedColumn = rowMetadata.getById((String)parameters.get("selected_column"));
            referenceValue = row.get(selectedColumn.getId());
        }
        String columnValue = BooleanUtils.toStringTrueFalse((boolean)this.fuzzyMatches(value, referenceValue, sensitivity));
        row.set(fuzzyMatches, columnValue);
    }

    private boolean fuzzyMatches(String value, String reference, int sensitivity) {
        int levenshteinDistance = StringUtils.getLevenshteinDistance((String)value, (String)reference);
        return levenshteinDistance <= sensitivity;
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.METADATA_CREATE_COLUMNS);
    }
}

