/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.text;

import java.util.EnumSet;
import java.util.Set;
import org.apache.avro.Schema;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#lowercase")
public class LowerCase
extends AbstractActionMetadata
implements ColumnAction {
    public static final String LOWER_CASE_ACTION_NAME = "lowercase";

    @Override
    public String getName() {
        return LOWER_CASE_ACTION_NAME;
    }

    @Override
    public String getCategory() {
        return ActionCategory.STRINGS.getDisplayName();
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        ColumnMetadata column = RowMetadataUtils.toColumnMetadata((Schema.Field)field);
        return Type.STRING.equals((Object)Type.get((String)column.getType()));
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        String columnId = context.getColumnId();
        String toLowerCase = row.get(columnId);
        if (toLowerCase != null) {
            row.set(columnId, toLowerCase.toLowerCase());
        }
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.VALUES_COLUMN);
    }
}

