/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.text;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.avro.Schema;
import org.apache.commons.lang.BooleanUtils;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.parameters.ParameterType;
import org.talend.dataprep.parameters.SelectParameter;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.actions.common.ReplaceOnValueHelper;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#matches_pattern")
public class MatchesPattern
extends AbstractActionMetadata
implements ColumnAction {
    public static final String MATCHES_PATTERN_ACTION_NAME = "matches_pattern";
    public static final String APPENDIX = "_matching";
    public static final String PATTERN_PARAMETER = "proposed_pattern";
    public static final String CUSTOM = "custom";
    public static final String REGEX_HELPER_KEY = "regex_helper";
    protected static final String MANUAL_PATTERN_PARAMETER = "manual_pattern";
    private ReplaceOnValueHelper regexParametersHelper = new ReplaceOnValueHelper();

    @Override
    public String getName() {
        return MATCHES_PATTERN_ACTION_NAME;
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        ColumnMetadata column = RowMetadataUtils.toColumnMetadata((Schema.Field)field);
        return Type.STRING.equals((Object)Type.get((String)column.getType()));
    }

    @Override
    public String getCategory() {
        return ActionCategory.STRINGS.getDisplayName();
    }

    @Override
    @Nonnull
    public List<Parameter> getParameters() {
        List<Parameter> parameters = super.getParameters();
        parameters.add((Parameter)SelectParameter.Builder.builder().name(PATTERN_PARAMETER).item("[a-z]+").item("[A-Z]+").item("[0-9]+").item("[a-zA-Z]+").item("[a-zA-Z0-9]+").item(CUSTOM, new Parameter[]{new Parameter(MANUAL_PATTERN_PARAMETER, ParameterType.REGEX, "")}).defaultValue("[a-zA-Z]+").build());
        return parameters;
    }

    private ReplaceOnValueHelper getPattern(Map<String, String> parameters) {
        if (CUSTOM.equals(parameters.get(PATTERN_PARAMETER))) {
            String jsonString = parameters.get(MANUAL_PATTERN_PARAMETER);
            return this.regexParametersHelper.build(jsonString, true);
        }
        return new ReplaceOnValueHelper(parameters.get(PATTERN_PARAMETER), "regex");
    }

    @Override
    public void compile(ActionContext context) {
        super.compile(context);
        if (context.getActionStatus() == ActionContext.ActionStatus.OK) {
            try {
                context.get(REGEX_HELPER_KEY, p -> this.getPattern(context.getParameters()));
            }
            catch (IllegalArgumentException e) {
                context.setActionStatus(ActionContext.ActionStatus.CANCELED);
            }
            String columnId = context.getColumnId();
            RowMetadata rowMetadata = context.getRowMetadata();
            ColumnMetadata column = rowMetadata.getById(columnId);
            if (column != null) {
                context.column(column.getName() + APPENDIX, r -> {
                    ColumnMetadata c = ColumnMetadata.Builder.column().name(column.getName() + APPENDIX).type(Type.BOOLEAN).empty(column.getQuality().getEmpty()).invalid(column.getQuality().getInvalid()).valid(column.getQuality().getValid()).headerSize(column.getHeaderSize()).build();
                    rowMetadata.insertAfter(columnId, c);
                    return c;
                });
            }
        }
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        String columnId = context.getColumnId();
        RowMetadata rowMetadata = context.getRowMetadata();
        ColumnMetadata column = rowMetadata.getById(columnId);
        String matchingColumn = context.column(column.getName() + APPENDIX);
        String value = row.get(columnId);
        String newValue = BooleanUtils.toStringTrueFalse((boolean)this.computeNewValue(value, context));
        row.set(matchingColumn, newValue);
    }

    protected boolean computeNewValue(String value, ActionContext actionContext) {
        if (actionContext.getActionStatus() != ActionContext.ActionStatus.OK) {
            return false;
        }
        ReplaceOnValueHelper replaceOnValueParameter = (ReplaceOnValueHelper)actionContext.get(REGEX_HELPER_KEY);
        return replaceOnValueParameter.matches(value);
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.METADATA_CREATE_COLUMNS);
    }
}

