/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.text;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.commons.lang.StringUtils;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.parameters.ParameterType;
import org.talend.dataprep.parameters.SelectParameter;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#padding")
public class Padding
extends AbstractActionMetadata
implements ColumnAction {
    public static final String ACTION_NAME = "padding";
    public static final String SIZE_PARAMETER = "size";
    public static final String PADDING_CHAR_PARAMETER = "padding_char";
    public static final String PADDING_POSITION_PARAMETER = "padding_position";
    public static final String LEFT_POSITION = "left";
    public static final String RIGHT_POSITION = "right";

    @Override
    public String getName() {
        return ACTION_NAME;
    }

    @Override
    public String getCategory() {
        return ActionCategory.STRINGS_ADVANCED.getDisplayName();
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        ColumnMetadata column = RowMetadataUtils.toColumnMetadata((Schema.Field)field);
        return Type.STRING.equals((Object)Type.get((String)column.getType())) || Type.NUMERIC.isAssignableFrom(Type.get((String)column.getType()));
    }

    @Override
    public List<Parameter> getParameters() {
        List<Parameter> parameters = super.getParameters();
        parameters.add(new Parameter(SIZE_PARAMETER, ParameterType.INTEGER, "5"));
        parameters.add(new Parameter(PADDING_CHAR_PARAMETER, ParameterType.STRING, "0"));
        parameters.add((Parameter)SelectParameter.Builder.builder().name(PADDING_POSITION_PARAMETER).item(LEFT_POSITION).item(RIGHT_POSITION).defaultValue(LEFT_POSITION).build());
        return parameters;
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        String columnId = context.getColumnId();
        Map parameters = context.getParameters();
        String original = row.get(columnId);
        int size = Integer.parseInt((String)parameters.get(SIZE_PARAMETER));
        char paddingChar = ((String)parameters.get(PADDING_CHAR_PARAMETER)).charAt(0);
        String paddingPosition = (String)parameters.get(PADDING_POSITION_PARAMETER);
        row.set(columnId, this.apply(original, size, paddingChar, paddingPosition));
    }

    protected String apply(String from, int size, char paddingChar, String position) {
        if (from == null) {
            return "";
        }
        if (position.equals(LEFT_POSITION)) {
            return StringUtils.leftPad((String)from, (int)size, (char)paddingChar);
        }
        return StringUtils.rightPad((String)from, (int)size, (char)paddingChar);
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.VALUES_COLUMN);
    }
}

