/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.text;

import java.util.EnumSet;
import java.util.Set;
import org.apache.avro.Schema;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#remove_non_alpha_num_chars")
public class RemoveNonAlphaNumChars
extends AbstractActionMetadata
implements ColumnAction {
    public static final String ACTION_NAME = "remove_non_alpha_num_chars";

    @Override
    public String getName() {
        return ACTION_NAME;
    }

    @Override
    public String getCategory() {
        return ActionCategory.STRINGS_ADVANCED.getDisplayName();
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        ColumnMetadata column = RowMetadataUtils.toColumnMetadata((Schema.Field)field);
        return Type.STRING.equals((Object)Type.get((String)column.getType()));
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        String columnId = context.getColumnId();
        String toCut = row.get(columnId);
        row.set(columnId, this.apply(toCut));
    }

    protected String apply(String from) {
        if (from == null) {
            return "";
        }
        return from.replaceAll("[\\p{Punct}\u00a3\u00b5\u00a7\u20ac\u00a5]", "");
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.VALUES_COLUMN);
    }
}

