/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.text;

import java.security.InvalidParameterException;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.avro.Schema;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.parameters.ParameterType;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.CellAction;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.actions.common.ReplaceOnValueHelper;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#replace_on_value")
public class ReplaceOnValue
extends AbstractActionMetadata
implements ColumnAction,
CellAction {
    public static final String REGEX_HELPER_KEY = "regex_helper";
    public static final String REPLACE_ON_VALUE_ACTION_NAME = "replace_on_value";
    public static final String CELL_VALUE_PARAMETER = "cell_value";
    public static final String REPLACE_VALUE_PARAMETER = "replace_value";
    public static final String REPLACE_ENTIRE_CELL_PARAMETER = "replace_entire_cell";
    private ReplaceOnValueHelper regexParametersHelper = new ReplaceOnValueHelper();

    @Override
    public String getName() {
        return REPLACE_ON_VALUE_ACTION_NAME;
    }

    @Override
    public String getCategory() {
        return ActionCategory.STRINGS.getDisplayName();
    }

    @Override
    public List<Parameter> getParameters() {
        List<Parameter> parameters = super.getParameters();
        parameters.add(new Parameter(CELL_VALUE_PARAMETER, ParameterType.REGEX, ""));
        parameters.add(new Parameter(REPLACE_VALUE_PARAMETER, ParameterType.STRING, ""));
        parameters.add(new Parameter(REPLACE_ENTIRE_CELL_PARAMETER, ParameterType.BOOLEAN, "false"));
        return parameters;
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        return Type.STRING.equals((Object)Type.get((String)RowMetadataUtils.toColumnMetadata((Schema.Field)field).getType()));
    }

    @Override
    public void compile(ActionContext actionContext) {
        super.compile(actionContext);
        if (actionContext.getActionStatus() == ActionContext.ActionStatus.OK) {
            Map parameters = actionContext.getParameters();
            String rawParam = (String)parameters.get(CELL_VALUE_PARAMETER);
            try {
                actionContext.get(REGEX_HELPER_KEY, p -> this.regexParametersHelper.build(rawParam, false));
            }
            catch (IllegalArgumentException e) {
                actionContext.setActionStatus(ActionContext.ActionStatus.CANCELED);
            }
        }
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        this.apply(row, context);
    }

    public void applyOnCell(DataSetRow row, ActionContext context) {
        this.apply(row, context);
    }

    private void apply(DataSetRow row, ActionContext context) {
        String value = row.get(context.getColumnId());
        if (value == null) {
            return;
        }
        String newValue = this.computeNewValue(context, value);
        row.set(context.getColumnId(), newValue);
    }

    protected String computeNewValue(ActionContext context, String originalValue) {
        if (originalValue == null) {
            return null;
        }
        if (context.getActionStatus() != ActionContext.ActionStatus.OK) {
            return originalValue;
        }
        Map parameters = context.getParameters();
        String replacement = (String)parameters.get(REPLACE_VALUE_PARAMETER);
        boolean replaceEntireCell = Boolean.valueOf((String)parameters.get(REPLACE_ENTIRE_CELL_PARAMETER));
        try {
            ReplaceOnValueHelper replaceOnValueParameter = (ReplaceOnValueHelper)context.get(REGEX_HELPER_KEY);
            boolean matches = replaceOnValueParameter.matches(originalValue);
            if (matches) {
                if (replaceOnValueParameter.getOperator().equals("regex")) {
                    Pattern pattern = replaceEntireCell ? replaceOnValueParameter.getPattern() : Pattern.compile(replaceOnValueParameter.getToken());
                    try {
                        return pattern.matcher(originalValue).replaceAll(replacement);
                    }
                    catch (IndexOutOfBoundsException e) {
                        return originalValue;
                    }
                }
                if (replaceEntireCell) {
                    return replacement;
                }
                return originalValue.replace(replaceOnValueParameter.getToken(), replacement);
            }
            return originalValue;
        }
        catch (InvalidParameterException e) {
            return originalValue;
        }
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.VALUES_COLUMN);
    }
}

