/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.text;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.avro.Schema;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.parameters.ParameterType;
import org.talend.dataprep.parameters.SelectParameter;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#split")
public class Split
extends AbstractActionMetadata
implements ColumnAction {
    public static final String SPLIT_ACTION_NAME = "split";
    public static final String SPLIT_APPENDIX = "_split_";
    public static final String NEW_COLUMNS_CONTEXT = "newColumns";
    protected static final String SEPARATOR_PARAMETER = "separator";
    protected static final String MANUAL_SEPARATOR_PARAMETER_STRING = "manual_separator_string";
    protected static final String MANUAL_SEPARATOR_PARAMETER_REGEX = "manual_separator_regex";
    protected static final String LIMIT = "limit";
    private static final Logger LOGGER = LoggerFactory.getLogger(Split.class);

    @Override
    public String getName() {
        return SPLIT_ACTION_NAME;
    }

    @Override
    public String getCategory() {
        return ActionCategory.SPLIT.getDisplayName();
    }

    @Override
    @Nonnull
    public List<Parameter> getParameters() {
        List<Parameter> parameters = super.getParameters();
        parameters.add(new Parameter(LIMIT, ParameterType.INTEGER, "2"));
        parameters.add((Parameter)SelectParameter.Builder.builder().name(SEPARATOR_PARAMETER).canBeBlank(true).item(":").item(";").item(",").item("@").item("-").item("_").item(" ", "space").item("\t", "tab").item("other (string)", new Parameter[]{new Parameter(MANUAL_SEPARATOR_PARAMETER_STRING, ParameterType.STRING, "")}).item("other (regex)", new Parameter[]{new Parameter(MANUAL_SEPARATOR_PARAMETER_REGEX, ParameterType.STRING, "")}).defaultValue(":").build());
        return parameters;
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        ColumnMetadata column = RowMetadataUtils.toColumnMetadata((Schema.Field)field);
        return Type.STRING.equals((Object)Type.get((String)column.getType()));
    }

    @Override
    public void compile(ActionContext context) {
        super.compile(context);
        if (context.getActionStatus() == ActionContext.ActionStatus.OK) {
            if (StringUtils.isEmpty((String)this.getSeparator(context))) {
                LOGGER.warn("Cannot split on an empty separator");
                context.setActionStatus(ActionContext.ActionStatus.CANCELED);
            }
            RowMetadata rowMetadata = context.getRowMetadata();
            String columnId = context.getColumnId();
            ColumnMetadata column = rowMetadata.getById(columnId);
            ArrayDeque<String> lastColumnId = new ArrayDeque<String>();
            Map parameters = context.getParameters();
            int limit = Integer.parseInt((String)parameters.get(LIMIT));
            ArrayList<String> newColumns = new ArrayList<String>();
            lastColumnId.push(columnId);
            for (int i = 0; i < limit; ++i) {
                int newColumnIndex = i + 1;
                newColumns.add(context.column(column.getName() + SPLIT_APPENDIX + i, r -> {
                    ColumnMetadata c = ColumnMetadata.Builder.column().type(Type.STRING).computedId("").name(column.getName() + SPLIT_APPENDIX + newColumnIndex).build();
                    lastColumnId.push(rowMetadata.insertAfter((String)lastColumnId.pop(), c));
                    return c;
                }));
            }
            context.get(NEW_COLUMNS_CONTEXT, p -> newColumns);
        }
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        Map parameters = context.getParameters();
        String columnId = context.getColumnId();
        String originalValue = row.get(columnId);
        if (originalValue == null) {
            return;
        }
        String realSeparator = this.getSeparator(context);
        if (!this.isRegexMode(context)) {
            realSeparator = '[' + realSeparator + ']';
        }
        int limit = Integer.parseInt((String)parameters.get(LIMIT));
        String[] split = originalValue.split(realSeparator, limit);
        List newColumns = (List)context.get(NEW_COLUMNS_CONTEXT);
        if (split.length != 0) {
            Iterator iterator = newColumns.iterator();
            for (int i = 0; i < limit && iterator.hasNext(); ++i) {
                String newValue = i < split.length ? split[i] : "";
                row.set((String)iterator.next(), newValue);
            }
        }
    }

    private boolean isRegexMode(ActionContext context) {
        Map parameters = context.getParameters();
        return StringUtils.equals((String)"other (regex)", (String)((String)parameters.get(SEPARATOR_PARAMETER)));
    }

    private String getSeparator(ActionContext context) {
        Map parameters = context.getParameters();
        if (StringUtils.equals((String)"other (string)", (String)((String)parameters.get(SEPARATOR_PARAMETER)))) {
            return (String)parameters.get(MANUAL_SEPARATOR_PARAMETER_STRING);
        }
        if (StringUtils.equals((String)"other (regex)", (String)((String)parameters.get(SEPARATOR_PARAMETER)))) {
            return (String)parameters.get(MANUAL_SEPARATOR_PARAMETER_REGEX);
        }
        return (String)parameters.get(SEPARATOR_PARAMETER);
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.METADATA_CREATE_COLUMNS);
    }
}

