/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.text;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.parameters.ParameterType;
import org.talend.dataprep.parameters.SelectParameter;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.actions.common.ImplicitParameters;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#substring")
public class Substring
extends AbstractActionMetadata
implements ColumnAction {
    public static final String SUBSTRING_ACTION_NAME = "substring";
    protected static final String FROM_MODE_PARAMETER = "from_mode";
    protected static final String FROM_BEGINNING = "from_beginning";
    protected static final String FROM_INDEX_PARAMETER = "from_index";
    protected static final String FROM_N_BEFORE_END_PARAMETER = "from_n_before_end";
    protected static final String TO_MODE_PARAMETER = "to_mode";
    protected static final String TO_END = "to_end";
    protected static final String TO_INDEX_PARAMETER = "to_index";
    protected static final String TO_N_BEFORE_END_PARAMETER = "to_n_before_end";
    private static final String APPENDIX = "_substring";

    @Override
    public String getName() {
        return SUBSTRING_ACTION_NAME;
    }

    @Override
    public String getCategory() {
        return ActionCategory.STRINGS.getDisplayName();
    }

    @Override
    public List<Parameter> getParameters() {
        Parameter fromIndexParameters = new Parameter(FROM_INDEX_PARAMETER, ParameterType.INTEGER, "0");
        Parameter fromNBeforeEndParameters = new Parameter(FROM_N_BEFORE_END_PARAMETER, ParameterType.INTEGER, "5");
        Parameter toIndexParameters = new Parameter(TO_INDEX_PARAMETER, ParameterType.INTEGER, "5");
        Parameter toNBeforeEndParameters = new Parameter(TO_N_BEFORE_END_PARAMETER, ParameterType.INTEGER, "1");
        SelectParameter toCompleteParameters = SelectParameter.Builder.builder().name(TO_MODE_PARAMETER).item(TO_END).item(TO_INDEX_PARAMETER, new Parameter[]{toIndexParameters}).item(TO_N_BEFORE_END_PARAMETER, new Parameter[]{toNBeforeEndParameters}).defaultValue(TO_INDEX_PARAMETER).build();
        SelectParameter toParametersWithoutIndexSelection = SelectParameter.Builder.builder().name(TO_MODE_PARAMETER).item(TO_END).item(TO_N_BEFORE_END_PARAMETER, new Parameter[]{toNBeforeEndParameters}).defaultValue(TO_END).build();
        SelectParameter fromParameters = SelectParameter.Builder.builder().name(FROM_MODE_PARAMETER).item(FROM_BEGINNING, new Parameter[]{toCompleteParameters}).item(FROM_INDEX_PARAMETER, new Parameter[]{fromIndexParameters, toCompleteParameters}).item(FROM_N_BEFORE_END_PARAMETER, new Parameter[]{fromNBeforeEndParameters, toParametersWithoutIndexSelection}).defaultValue(FROM_BEGINNING).build();
        List parameters = ImplicitParameters.getParameters();
        parameters.add(fromParameters);
        return parameters;
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        ColumnMetadata column = RowMetadataUtils.toColumnMetadata((Schema.Field)field);
        return Type.STRING.equals((Object)Type.get((String)column.getType()));
    }

    @Override
    public void compile(ActionContext context) {
        super.compile(context);
        if (context.getActionStatus() == ActionContext.ActionStatus.OK) {
            RowMetadata rowMetadata = context.getRowMetadata();
            String columnId = context.getColumnId();
            ColumnMetadata column = rowMetadata.getById(columnId);
            context.column(column.getName() + APPENDIX, r -> {
                ColumnMetadata c = ColumnMetadata.Builder.column().name(column.getName() + APPENDIX).type(Type.get((String)column.getType())).empty(column.getQuality().getEmpty()).invalid(column.getQuality().getInvalid()).valid(column.getQuality().getValid()).headerSize(column.getHeaderSize()).build();
                rowMetadata.insertAfter(columnId, c);
                return c;
            });
        }
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        RowMetadata rowMetadata = context.getRowMetadata();
        String columnId = context.getColumnId();
        ColumnMetadata column = rowMetadata.getById(columnId);
        String substringColumn = context.column(column.getName() + APPENDIX);
        String value = row.get(columnId);
        if (value == null) {
            return;
        }
        Map parameters = context.getParameters();
        int realFromIndex = this.getStartIndex(parameters, value);
        int realToIndex = this.getEndIndex(parameters, value);
        try {
            String newValue = value.substring(realFromIndex, realToIndex);
            row.set(substringColumn, newValue);
        }
        catch (IndexOutOfBoundsException e) {
            row.set(substringColumn, "");
        }
    }

    private int getEndIndex(Map<String, String> parameters, String value) {
        switch (parameters.get(TO_MODE_PARAMETER)) {
            case "to_index": {
                return Math.min(Integer.parseInt(parameters.get(TO_INDEX_PARAMETER)), value.length());
            }
            case "to_n_before_end": {
                int nbChars = Math.max(0, Integer.parseInt(parameters.get(TO_N_BEFORE_END_PARAMETER)));
                return Math.max(0, value.length() - nbChars);
            }
        }
        return value.length();
    }

    private int getStartIndex(Map<String, String> parameters, String value) {
        switch (parameters.get(FROM_MODE_PARAMETER)) {
            case "from_index": {
                int index = Math.max(0, Integer.parseInt(parameters.get(FROM_INDEX_PARAMETER)));
                return Math.min(index, value.length());
            }
            case "from_n_before_end": {
                return Math.max(0, value.length() - Integer.parseInt(parameters.get(FROM_N_BEFORE_END_PARAMETER)));
            }
        }
        return 0;
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.METADATA_CREATE_COLUMNS);
    }
}

