/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.text;

import java.util.EnumSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.avro.Schema;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#trim")
public class Trim
extends AbstractActionMetadata
implements ColumnAction {
    public static final String TRIM_ACTION_NAME = "trim";
    private static final String TRIM_PATTERN = "trimPattern";

    @Override
    public String getName() {
        return TRIM_ACTION_NAME;
    }

    @Override
    public String getCategory() {
        return ActionCategory.STRINGS.getDisplayName();
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        ColumnMetadata column = RowMetadataUtils.toColumnMetadata((Schema.Field)field);
        return Type.STRING.equals((Object)Type.get((String)column.getType()));
    }

    @Override
    public void compile(ActionContext actionContext) {
        super.compile(actionContext);
        if (actionContext.getActionStatus() == ActionContext.ActionStatus.OK) {
            Pattern pattern = Pattern.compile("(^\\h*)|(\\h*$)");
            actionContext.get(TRIM_PATTERN, parameters -> pattern);
        }
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        String columnId = context.getColumnId();
        String toTrim = row.get(columnId);
        if (toTrim != null) {
            Pattern trimPattern = (Pattern)context.get(TRIM_PATTERN);
            row.set(columnId, trimPattern.matcher(toTrim).replaceAll(""));
        }
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.VALUES_COLUMN);
    }
}

