/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.api.action;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.avro.generic.GenericRecord;
import org.talend.dataprep.api.action.ActionDefinitionDeserializer;
import org.talend.dataprep.api.action.ActionForm;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.transformation.actions.category.ScopeCategory;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@JsonDeserialize(using=ActionDefinitionDeserializer.class)
public interface ActionDefinition
extends Serializable {
    public String getName();

    public String getCategory(Locale var1);

    public List<String> getActionScope();

    public boolean isDynamic();

    @Deprecated
    public String getLabel(Locale var1);

    @Deprecated
    public String getDescription(Locale var1);

    @Deprecated
    public String getDocUrl(Locale var1);

    @Deprecated
    public List<Parameter> getParameters(Locale var1);

    public Set<Behavior> getBehavior();

    public Function<GenericRecord, GenericRecord> action(List<Parameter> var1);

    public boolean acceptScope(ScopeCategory var1);

    public ActionDefinition adapt(ColumnMetadata var1);

    public ActionDefinition adapt(ScopeCategory var1);

    public boolean acceptField(ColumnMetadata var1);

    public void compile(ActionContext var1);

    public boolean implicitFilter();

    default public ActionForm getActionForm(Locale locale) {
        return this.getActionForm(locale, Locale.US);
    }

    default public ActionForm getActionForm(Locale locale, Locale alternateLocale) {
        ActionForm form = new ActionForm();
        form.setName(this.getName());
        form.setCategory(this.getCategory(locale));
        form.setActionScope(this.getActionScope());
        form.setDynamic(this.isDynamic());
        form.setDescription(this.getDescription(locale));
        form.setLabel(this.getLabel(locale));
        form.setDocUrl(this.getDocUrl(locale));
        form.setParameters(this.getParameters(locale));
        if (!Objects.equals(locale, alternateLocale)) {
            form.setAlternateDescription(this.getDescription(alternateLocale));
            form.setAlternateLabel(this.getLabel(alternateLocale));
        }
        return form;
    }

    public static enum Behavior {
        VALUES_ALL,
        METADATA_CHANGE_ROW,
        METADATA_CHANGE_TYPE,
        METADATA_CHANGE_NAME,
        METADATA_CREATE_COLUMNS,
        METADATA_COPY_COLUMNS,
        METADATA_DELETE_COLUMNS,
        VALUES_DELETE_ROWS,
        VALUES_COLUMN,
        VALUES_MULTIPLE_COLUMNS,
        NEED_STATISTICS_PATTERN,
        NEED_STATISTICS_INVALID,
        FORBID_DISTRIBUTED;

    }
}

