/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.api.action;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.transformation.actions.Providers;
import org.talend.dataprep.transformation.pipeline.ActionRegistry;

public class ActionDefinitionDeserializer
extends JsonDeserializer<ActionDefinition> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionDefinitionDeserializer.class);

    public ActionDefinition deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        TreeNode treeNode = jp.readValueAsTree();
        TreeNode nodeName = treeNode.get("name");
        if (nodeName instanceof TextNode) {
            String name = ((TextNode)nodeName).asText();
            return Providers.get(ActionRegistry.class).get(name);
        }
        LOGGER.error("No action available for: {}.", (Object)treeNode);
        return null;
    }
}

