/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.api.dataset;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.talend.dataprep.api.dataset.Quality;
import org.talend.dataprep.api.dataset.statistics.SemanticDomain;
import org.talend.dataprep.api.dataset.statistics.Statistics;
import org.talend.dataprep.api.type.Type;

public class ColumnMetadata
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="quality")
    private final Quality quality = new Quality();
    @JsonProperty(value="id")
    private String id;
    private String name;
    @JsonProperty(value="type")
    private String typeName = "N/A";
    private int headerSize = 0;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="__tdpColumnDiff")
    private String diffFlagValue;
    @JsonProperty(value="statistics")
    private Statistics statistics = new Statistics();
    @JsonProperty(value="domain")
    private String domain = "";
    @JsonProperty(value="domainLabel")
    private String domainLabel = "";
    @JsonProperty(value="domainFrequency")
    private float domainFrequency;
    @JsonProperty(value="semanticDomains")
    private List<SemanticDomain> semanticDomains = Collections.emptyList();
    @JsonProperty(value="domainForced")
    private boolean domainForced;
    @JsonProperty(value="typeForced")
    private boolean typeForced;

    public ColumnMetadata() {
    }

    private ColumnMetadata(String name, String typeName) {
        this.name = name;
        this.typeName = typeName;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.typeName;
    }

    public void setType(String typeName) {
        this.typeName = typeName;
    }

    public String getDiffFlagValue() {
        return this.diffFlagValue;
    }

    public void setDiffFlagValue(String diffFlagValue) {
        this.diffFlagValue = diffFlagValue;
    }

    public int getHeaderSize() {
        return this.headerSize;
    }

    public void setHeaderSize(int headerSize) {
        this.headerSize = headerSize;
    }

    public Quality getQuality() {
        return this.quality;
    }

    public boolean isDomainForced() {
        return this.domainForced;
    }

    public void setDomainForced(boolean domainForced) {
        this.domainForced = domainForced;
    }

    public boolean isTypeForced() {
        return this.typeForced;
    }

    public void setTypeForced(boolean typeForced) {
        this.typeForced = typeForced;
    }

    public boolean compatible(ColumnMetadata columnMetadata) {
        if (columnMetadata != null) {
            return StringUtils.equals((String)this.typeName, (String)columnMetadata.getType()) && StringUtils.equalsIgnoreCase((String)this.name, (String)columnMetadata.getName());
        }
        return false;
    }

    public boolean equals(Object obj) {
        return Optional.ofNullable(obj).filter(that -> that instanceof ColumnMetadata).map(that -> (ColumnMetadata)that).filter(that -> Objects.equals(this.getDiffFlagValue(), that.getDiffFlagValue())).filter(that -> Objects.equals(this.getId(), that.getId())).filter(that -> Objects.equals(this.getName(), that.getName())).filter(that -> Objects.equals(this.getType(), that.getType())).isPresent();
    }

    public int hashCode() {
        int result = this.getId().hashCode();
        result = 31 * result + this.getType().hashCode();
        if (this.name != null) {
            result = 31 * result + this.getName().hashCode();
        }
        return result;
    }

    public String toString() {
        return "ColumnMetadata{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", typeName='" + this.typeName + '\'' + ", quality=" + this.quality + ", headerSize=" + this.headerSize + ", diffFlagValue='" + this.diffFlagValue + '\'' + ", statistics='" + this.statistics + '\'' + ", domain='" + this.domain + '\'' + ", domainLabel='" + this.domainLabel + '\'' + ", semanticDomains=" + this.semanticDomains + '}';
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public void setStatistics(Statistics statistics) {
        this.statistics = statistics == null ? new Statistics() : statistics;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getDomainLabel() {
        return this.domainLabel;
    }

    public void setDomainLabel(String domainLabel) {
        this.domainLabel = domainLabel;
    }

    public List<SemanticDomain> getSemanticDomains() {
        return this.semanticDomains;
    }

    public void setSemanticDomains(List<SemanticDomain> semanticDomains) {
        this.semanticDomains = semanticDomains;
    }

    public float getDomainFrequency() {
        return this.domainFrequency;
    }

    public void setDomainFrequency(float domainFrequency) {
        this.domainFrequency = domainFrequency;
    }

    public void setId(String id) {
        this.id = id;
    }

    public static class Builder {
        private String id;
        private String name;
        private Type type;
        private int empty;
        private int invalid;
        private int valid;
        private int headerSize;
        private String diffFlagValue = null;
        private Statistics statistics;
        private String domain;
        private String domainLabel;
        private float domainFrequency;
        private List<SemanticDomain> semanticDomains;
        private boolean domainForced;
        private boolean typeForced;

        public static Builder column() {
            return new Builder();
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder id(int id) {
            DecimalFormat format = new DecimalFormat("0000");
            return this.computedId(format.format(id));
        }

        public Builder computedId(String computedId) {
            this.id = computedId;
            return this;
        }

        public Builder statistics(Statistics statistics) {
            this.statistics = statistics;
            return this;
        }

        public Builder type(Type type) {
            if (type == null) {
                throw new IllegalArgumentException("Type cannot be null.");
            }
            this.type = type;
            return this;
        }

        public Builder empty(int value) {
            this.empty = value;
            return this;
        }

        public Builder invalid(int value) {
            this.invalid = value;
            return this;
        }

        public Builder valid(int value) {
            this.valid = value;
            return this;
        }

        public Builder headerSize(int headerSize) {
            this.headerSize = headerSize;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder domainLabel(String domainLabel) {
            this.domainLabel = domainLabel;
            return this;
        }

        public Builder domainFrequency(float domainFrequency) {
            this.domainFrequency = domainFrequency;
            return this;
        }

        public Builder semanticDomains(List<SemanticDomain> semanticDomains) {
            this.semanticDomains = semanticDomains;
            return this;
        }

        public Builder semanticDomainForce(boolean semanticDomainForced) {
            this.domainForced = semanticDomainForced;
            return this;
        }

        public Builder typeForce(boolean typeForced) {
            this.typeForced = typeForced;
            return this;
        }

        public Builder copy(ColumnMetadata original) {
            this.id = original.getId();
            this.name = original.getName();
            Quality originalQuality = original.getQuality();
            this.empty = originalQuality.getEmpty();
            this.invalid = originalQuality.getInvalid();
            this.valid = originalQuality.getValid();
            this.headerSize = original.getHeaderSize();
            this.type = Type.get(original.getType());
            this.diffFlagValue = original.getDiffFlagValue();
            this.statistics = original.getStatistics();
            this.domain = original.getDomain();
            this.domainLabel = original.getDomainLabel();
            this.domainFrequency = original.getDomainFrequency();
            this.semanticDomains = original.getSemanticDomains();
            this.domainForced = original.isDomainForced();
            this.typeForced = original.isTypeForced();
            return this;
        }

        public Builder copyMatchingEmptyColumnMetadata(ColumnMetadata original) {
            this.id = original.getId();
            this.name = original.getName();
            this.empty = 0;
            this.invalid = 0;
            this.valid = 0;
            this.type = Type.get(original.getType());
            this.domain = original.getDomain();
            this.domainLabel = original.getDomainLabel();
            this.semanticDomains = original.getSemanticDomains();
            return this;
        }

        public ColumnMetadata build() {
            ColumnMetadata columnMetadata = new ColumnMetadata(this.name, this.type.getName());
            columnMetadata.setId(this.id);
            columnMetadata.getQuality().setEmpty(this.empty);
            columnMetadata.getQuality().setInvalid(this.invalid);
            columnMetadata.getQuality().setValid(this.valid);
            columnMetadata.setHeaderSize(this.headerSize);
            columnMetadata.setDiffFlagValue(this.diffFlagValue);
            columnMetadata.setStatistics(this.statistics == null ? new Statistics() : this.statistics);
            columnMetadata.setDomain(this.domain == null ? "" : this.domain);
            columnMetadata.setDomainLabel(this.domainLabel == null ? "" : this.domainLabel);
            columnMetadata.setDomainFrequency(this.domainFrequency);
            columnMetadata.setSemanticDomains(this.semanticDomains == null ? Collections.emptyList() : this.semanticDomains);
            columnMetadata.setDomainForced(this.domainForced);
            columnMetadata.setTypeForced(this.typeForced);
            return columnMetadata;
        }
    }
}

