/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.api.dataset;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DataSetContent
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="records")
    private long nbRecords = 0L;
    @JsonProperty(value="nbLinesHeader")
    private int nbLinesInHeader;
    @JsonProperty(value="nbLinesFooter")
    private int nbLinesInFooter;
    @JsonProperty(value="type")
    private String mediaType;
    @JsonProperty(value="parameters")
    private Map<String, String> parameters = new HashMap<String, String>();
    @JsonProperty(value="formatGuess")
    private String formatFamilyId;
    @JsonProperty(value="limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Optional<Long> limit = Optional.empty();

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void addParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public String getFormatFamilyId() {
        return this.formatFamilyId;
    }

    public void setFormatFamilyId(String formatFamilyId) {
        this.formatFamilyId = formatFamilyId;
    }

    public long getNbRecords() {
        return this.nbRecords;
    }

    public void setNbRecords(long lines) {
        this.nbRecords = lines;
    }

    public int getNbLinesInHeader() {
        return this.nbLinesInHeader;
    }

    public void setNbLinesInHeader(int nbLinesInHeader) {
        this.nbLinesInHeader = nbLinesInHeader;
    }

    public int getNbLinesInFooter() {
        return this.nbLinesInFooter;
    }

    public void setNbLinesInFooter(int nbLinesInFooter) {
        this.nbLinesInFooter = nbLinesInFooter;
    }

    public Optional<Long> getLimit() {
        return this.limit;
    }

    public void setLimit(Long limit) {
        if (limit != null) {
            this.limit = Optional.of(limit);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSetContent that = (DataSetContent)o;
        return Objects.equals(this.nbRecords, that.nbRecords) && Objects.equals(this.nbLinesInHeader, that.nbLinesInHeader) && Objects.equals(this.nbLinesInFooter, that.nbLinesInFooter) && Objects.equals(this.limit, that.limit) && Objects.equals(this.mediaType, that.mediaType) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.formatFamilyId, that.formatFamilyId);
    }

    public int hashCode() {
        return Objects.hash(this.nbRecords, this.nbLinesInHeader, this.nbLinesInFooter, this.limit, this.mediaType, this.parameters, this.formatFamilyId);
    }

    public String toString() {
        return "DataSetContent{formatFamilyId='" + this.formatFamilyId + '\'' + ", mediaType='" + this.mediaType + '\'' + ", nbRecords=" + this.nbRecords + ", limit=" + this.limit + ", nbLinesInHeader=" + this.nbLinesInHeader + ", nbLinesInFooter=" + this.nbLinesInFooter + ", parameters=" + this.parameters + '}';
    }
}

