/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.api.dataset;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.LightweightExportableDataSet;

public final class DataSetDataReader {
    private static final String INCORRECT_OBJECT_STRUCTURE_ERROR_MESSAGE = "Malformed lookup data from DataPrep server.";
    private ObjectMapper mapper;

    public DataSetDataReader(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public LightweightExportableDataSet parseAndMapLookupDataSet(InputStream inputStream, String joinOnColumn) throws IOException {
        Validate.isTrue((inputStream != null ? 1 : 0) != 0, (String)"The provided input stream must not be null", (Object[])new Object[0]);
        try (JsonParser jsonParser = this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).getFactory().createParser((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            LightweightExportableDataSet lookupDataset = new LightweightExportableDataSet();
            RowMetadata rowMetadata = new RowMetadata();
            JsonToken currentToken = jsonParser.nextToken();
            Validate.isTrue((currentToken == JsonToken.START_OBJECT ? 1 : 0) != 0, (String)INCORRECT_OBJECT_STRUCTURE_ERROR_MESSAGE, (Object[])new Object[0]);
            while (currentToken != JsonToken.END_OBJECT && !jsonParser.isClosed()) {
                currentToken = jsonParser.nextToken();
                String currentField = jsonParser.getCurrentName();
                if ("metadata".equalsIgnoreCase(currentField)) {
                    JsonToken metadataStartToken = jsonParser.nextToken();
                    Validate.isTrue((metadataStartToken == JsonToken.START_OBJECT ? 1 : 0) != 0, (String)INCORRECT_OBJECT_STRUCTURE_ERROR_MESSAGE, (Object[])new Object[0]);
                    rowMetadata = this.parseDataSetMetadataAndReturnRowMetadata(jsonParser);
                    lookupDataset.setMetadata(rowMetadata);
                    continue;
                }
                if (!"records".equalsIgnoreCase(currentField)) continue;
                JsonToken recordsStartToken = jsonParser.nextToken();
                Validate.isTrue((recordsStartToken == JsonToken.START_ARRAY ? 1 : 0) != 0, (String)INCORRECT_OBJECT_STRUCTURE_ERROR_MESSAGE, (Object[])new Object[0]);
                lookupDataset.setRecords(this.parseRecords(jsonParser, rowMetadata, joinOnColumn));
            }
            if (lookupDataset.isEmpty()) {
                throw new IOException("No lookup data has been retrieved when trying to parse the specified data set.");
            }
            LightweightExportableDataSet lightweightExportableDataSet = lookupDataset;
            return lightweightExportableDataSet;
        }
    }

    private RowMetadata parseDataSetMetadataAndReturnRowMetadata(JsonParser jsonParser) throws IOException {
        try {
            JsonNode treeNode = (JsonNode)jsonParser.readValueAsTree();
            JsonNode columns = treeNode.get("columns");
            ArrayList<ColumnMetadata> columnsParsed = new ArrayList<ColumnMetadata>();
            if (columns.isArray()) {
                for (int columnId = 0; columnId < columns.size(); ++columnId) {
                    JsonNode column = columns.get(columnId);
                    columnsParsed.add((ColumnMetadata)this.mapper.reader(ColumnMetadata.class).readValue(column));
                }
            }
            return new RowMetadata(columnsParsed);
        }
        catch (IOException e) {
            throw new IOException("Unable to parse and retrieve the row metadata", e);
        }
    }

    private Map<String, Map<String, String>> parseRecords(JsonParser jsonParser, RowMetadata rowMetadata, String joinOnColumn) throws IOException {
        try {
            JsonToken firstToken = jsonParser.nextToken();
            Validate.isTrue((firstToken == JsonToken.START_OBJECT ? 1 : 0) != 0, (String)INCORRECT_OBJECT_STRUCTURE_ERROR_MESSAGE, (Object[])new Object[0]);
            HashMap<String, Map<String, String>> lookupDataset = new HashMap<String, Map<String, String>>();
            Iterator mapIterator = jsonParser.readValuesAs((TypeReference)new TypeReference<Map<String, String>>(){});
            while (mapIterator.hasNext()) {
                Map recordMap = (Map)mapIterator.next();
                lookupDataset.put((String)recordMap.get(joinOnColumn), recordMap);
            }
            Validate.isTrue((!lookupDataset.isEmpty() ? 1 : 0) != 0, (String)"No lookup record has been retrieved when trying to parse the retrieved data set.", (Object[])new Object[0]);
            return lookupDataset;
        }
        catch (IOException e) {
            throw new IOException("Unable to parse and retrieve the records of the data set", e);
        }
    }
}

