/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.api.dataset;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.io.Serializable;
import java.util.Objects;
import org.talend.dataprep.api.dataset.DataSetContent;
import org.talend.dataprep.api.dataset.DataSetGovernance;
import org.talend.dataprep.api.dataset.DataSetLifecycle;
import org.talend.dataprep.api.dataset.DataSetLocation;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.schema.Schema;

public class DataSetMetadata
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    @JsonUnwrapped
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="columns")
    private RowMetadata rowMetadata;
    @JsonProperty(value="lifecycle")
    private DataSetLifecycle lifecycle = new DataSetLifecycle();
    @JsonProperty(value="content")
    @JsonUnwrapped
    private DataSetContent content = new DataSetContent();
    @JsonProperty(value="governance")
    @JsonUnwrapped
    private DataSetGovernance governance = new DataSetGovernance();
    @JsonProperty(value="location")
    private DataSetLocation location;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="author")
    private String author;
    @JsonProperty(value="created")
    private long creationDate;
    @JsonProperty(value="lastModificationDate")
    private long lastModificationDate;
    @JsonProperty(value="sheetName")
    private String sheetName;
    @JsonProperty(value="app-version")
    private String appVersion;
    @JsonProperty(value="draft")
    private boolean draft = false;
    @JsonProperty(value="schemaParserResult")
    private Schema schemaParserResult;
    @JsonProperty(value="encoding")
    private String encoding = "UTF-8";
    @JsonProperty(value="dataSetSize")
    private long dataSetSize;
    private String tag;

    public DataSetMetadata() {
    }

    public DataSetMetadata(String id, String name, String author, long creationDate, long lastModificationDate, RowMetadata rowMetadata, String appVersion) {
        this.id = id;
        this.name = name;
        this.author = author;
        this.creationDate = creationDate;
        this.lastModificationDate = lastModificationDate;
        this.rowMetadata = rowMetadata;
        this.appVersion = appVersion;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setCreationDate(long creationDate) {
        this.creationDate = creationDate;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public String getId() {
        return this.id;
    }

    public RowMetadata getRowMetadata() {
        return this.rowMetadata;
    }

    public void setRowMetadata(RowMetadata rowMetadata) {
        this.rowMetadata = rowMetadata;
    }

    public DataSetLifecycle getLifecycle() {
        return this.lifecycle;
    }

    public void setLifecycle(DataSetLifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public DataSetContent getContent() {
        return this.content;
    }

    public void setContent(DataSetContent content) {
        this.content = content;
    }

    public DataSetGovernance getGovernance() {
        return this.governance;
    }

    public void setGovernance(DataSetGovernance governance) {
        this.governance = governance;
    }

    public DataSetLocation getLocation() {
        return this.location;
    }

    public void setLocation(DataSetLocation location) {
        this.location = location;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public long getLastModificationDate() {
        return this.lastModificationDate;
    }

    public void setLastModificationDate(long lastModificationDate) {
        this.lastModificationDate = lastModificationDate;
    }

    public boolean isDraft() {
        return this.draft;
    }

    public void setDraft(boolean draft) {
        this.draft = draft;
    }

    public Schema getSchemaParserResult() {
        return this.schemaParserResult;
    }

    public void setSchemaParserResult(Schema schemaParserResult) {
        this.schemaParserResult = schemaParserResult;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public long getDataSetSize() {
        return this.dataSetSize;
    }

    public void setDataSetSize(long dataSetSize) {
        this.dataSetSize = dataSetSize;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public boolean compatible(DataSetMetadata other) {
        return other != null && (this.rowMetadata != null ? this.rowMetadata.compatible(other.getRowMetadata()) : other.getRowMetadata() == null);
    }

    public String toString() {
        return "DataSetMetadata{id='" + this.id + '\'' + ", rowMetadata=" + this.rowMetadata + ", appVersion=" + this.appVersion + ", lifecycle=" + this.lifecycle + ", content=" + this.content + ", dataSetSize=" + this.dataSetSize + ", governance=" + this.governance + ", name='" + this.name + '\'' + ", author='" + this.author + '\'' + ", creationDate=" + this.creationDate + ", lastModificationDate=" + this.lastModificationDate + ", sheetName='" + this.sheetName + '\'' + ", draft=" + this.draft + ", schemaParserResult=" + this.schemaParserResult + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSetMetadata that = (DataSetMetadata)o;
        return Objects.equals(this.creationDate, that.creationDate) && Objects.equals(this.lastModificationDate, that.lastModificationDate) && Objects.equals(this.draft, that.draft) && Objects.equals(this.id, that.id) && Objects.equals(this.rowMetadata, that.rowMetadata) && Objects.equals(this.lifecycle, that.lifecycle) && Objects.equals(this.dataSetSize, that.dataSetSize) && Objects.equals(this.content, that.content) && Objects.equals(this.governance, that.governance) && Objects.equals(this.location, that.location) && Objects.equals(this.name, that.name) && Objects.equals(this.author, that.author) && Objects.equals(this.sheetName, that.sheetName) && Objects.equals(this.schemaParserResult, that.schemaParserResult) && Objects.equals(this.appVersion, that.appVersion);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.rowMetadata, this.lifecycle, this.dataSetSize, this.content, this.governance, this.location, this.name, this.author, this.creationDate, this.lastModificationDate, this.sheetName, this.draft, this.schemaParserResult, this.appVersion);
    }
}

