/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.api.dataset;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.avro.Schema;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.json.ColumnContextDeserializer;
import org.talend.dataprep.api.dataset.row.Flag;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;

public class RowMetadata
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(RowMetadata.class);
    private static final String COLUMN_ID_PATTERN = "0000";
    @JsonProperty(value="columns")
    @JsonDeserialize(using=ColumnContextDeserializer.class)
    private final List<ColumnMetadata> columns = new ArrayList<ColumnMetadata>();
    @JsonProperty(value="nextId")
    private int nextId = 0;

    public RowMetadata() {
    }

    public RowMetadata(List<ColumnMetadata> columns) {
        this.setColumns(columns);
    }

    public List<ColumnMetadata> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public boolean compatible(RowMetadata other) {
        if (other == null || this.columns.size() != other.getColumns().size()) {
            return false;
        }
        int size = this.columns.size();
        List<ColumnMetadata> otherColumns = other.getColumns();
        for (int i = 0; i < size; ++i) {
            if (this.columns.get(i).compatible(otherColumns.get(i))) continue;
            return false;
        }
        return true;
    }

    public void setColumns(List<ColumnMetadata> columnMetadata) {
        this.columns.clear();
        this.nextId = 0;
        columnMetadata.forEach(this::addColumn);
    }

    public ColumnMetadata addColumn(ColumnMetadata columnMetadata) {
        return this.addColumn(columnMetadata, this.columns.size());
    }

    public ColumnMetadata deleteColumnById(String id) {
        ColumnMetadata column = this.getById(id);
        if (column != null && this.columns.remove(column)) {
            return column;
        }
        return null;
    }

    private ColumnMetadata addColumn(ColumnMetadata columnMetadata, int index) {
        String columnIdFromMetadata = columnMetadata.getId();
        DecimalFormat columnIdFormat = new DecimalFormat(COLUMN_ID_PATTERN);
        if (StringUtils.isBlank((String)columnIdFromMetadata)) {
            columnMetadata.setId(columnIdFormat.format(this.nextId));
            ++this.nextId;
        } else {
            try {
                int columnId = columnIdFormat.parse(columnIdFromMetadata).intValue();
                int possibleNextId = columnId + 1;
                if (possibleNextId > this.nextId) {
                    this.nextId = possibleNextId;
                }
            }
            catch (ParseException e) {
                LOGGER.error("Unable to parse column id from metadata '" + columnIdFromMetadata + "'", (Throwable)e);
            }
        }
        this.columns.add(index, columnMetadata);
        return columnMetadata;
    }

    public int size() {
        return this.columns.size();
    }

    public ColumnMetadata getById(String wantedId) {
        if (wantedId == null) {
            return null;
        }
        for (ColumnMetadata column : this.columns) {
            if (!wantedId.equals(column.getId())) continue;
            return column;
        }
        return null;
    }

    public void diff(RowMetadata reference) {
        this.columns.forEach(column -> {
            if (reference.getById(column.getId()) == null) {
                column.setDiffFlagValue(Flag.NEW.getValue());
            }
        });
        this.columns.forEach(column -> {
            ColumnMetadata referenceColumn = reference.getById(column.getId());
            if (referenceColumn != null && this.columnHasChanged((ColumnMetadata)column, referenceColumn)) {
                column.setDiffFlagValue(Flag.UPDATE.getValue());
            }
        });
        reference.getColumns().forEach(referenceColumn -> {
            if (this.getById(referenceColumn.getId()) == null) {
                int position = this.findColumnPosition(reference.getColumns(), referenceColumn.getId());
                referenceColumn.setDiffFlagValue(Flag.DELETE.getValue());
                this.columns.add(position, (ColumnMetadata)referenceColumn);
            }
        });
    }

    private boolean columnHasChanged(ColumnMetadata column, ColumnMetadata reference) {
        return !Objects.equals(column.getName(), reference.getName()) || !Objects.equals(column.getDomain(), reference.getDomain()) || !Objects.equals(column.getType(), reference.getType());
    }

    private int findColumnPosition(List<ColumnMetadata> columns, String colId) {
        for (int i = 0; i < columns.size(); ++i) {
            if (!columns.get(i).getId().equals(colId)) continue;
            return i;
        }
        return columns.size();
    }

    public String toString() {
        return "RowMetadata{columns=" + this.columns + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().isInstance(o)) {
            return false;
        }
        RowMetadata that = (RowMetadata)o;
        return Objects.equals(this.columns, that.columns);
    }

    public int hashCode() {
        return Objects.hash(this.columns);
    }

    public void update(@Nonnull String columnId, @Nonnull ColumnMetadata column) {
        if (this.getById(columnId) == null) {
            return;
        }
        int updatePos = 0;
        for (ColumnMetadata columnMetadata : this.columns) {
            if (columnId.equals(columnMetadata.getId())) break;
            ++updatePos;
        }
        this.columns.set(updatePos, column);
    }

    public String insertAfter(@Nonnull String columnId, @Nonnull ColumnMetadata column) {
        int insertIndex = 0;
        for (ColumnMetadata columnMetadata : this.columns) {
            ++insertIndex;
            if (!columnId.equals(columnMetadata.getId())) continue;
            break;
        }
        this.addColumn(column, insertIndex);
        return column.getId();
    }

    public RowMetadata clone() {
        ArrayList copyColumns = new ArrayList(this.columns.size());
        this.columns.forEach(col -> copyColumns.add(ColumnMetadata.Builder.column().copy((ColumnMetadata)col).build()));
        RowMetadata clone = new RowMetadata(new ArrayList<ColumnMetadata>(copyColumns));
        clone.nextId = this.nextId;
        return clone;
    }

    public Schema toSchema() {
        return RowMetadataUtils.toSchema(this);
    }
}

