/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.api.dataset.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.exception.error.ErrorCode;
import org.talend.dataprep.BaseErrorCodes;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;

public class DataSetRowIterator
implements Iterator<DataSetRow> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSetRowIterator.class);
    private final JsonParser parser;
    private DataSetRow row;
    private final RowMetadata rowMetadata;

    public DataSetRowIterator(JsonParser parser, RowMetadata rowMetadata) {
        this.parser = parser;
        this.rowMetadata = rowMetadata;
        this.row = new DataSetRow(rowMetadata);
    }

    public DataSetRowIterator(InputStream inputStream) {
        try {
            this.parser = new JsonFactory().createParser((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            this.rowMetadata = new RowMetadata();
            this.row = new DataSetRow(this.rowMetadata);
        }
        catch (IOException e) {
            throw new TalendRuntimeException((ErrorCode)BaseErrorCodes.UNABLE_TO_PARSE_JSON, (Throwable)e);
        }
    }

    @Override
    public boolean hasNext() {
        String currentName;
        if (this.parser.isClosed()) {
            return false;
        }
        try {
            currentName = this.parser.getCurrentName();
        }
        catch (IOException e) {
            LOGGER.debug("Unable to get current JSON field name.", (Throwable)e);
            return false;
        }
        JsonToken currentToken = this.parser.getCurrentToken();
        if ("records".equals(currentName)) {
            return currentToken != null && currentToken != JsonToken.END_ARRAY;
        }
        return currentToken != JsonToken.END_ARRAY;
    }

    @Override
    public DataSetRow next() {
        try {
            JsonToken nextToken;
            String currentFieldName = "";
            this.row.clear();
            block9: while ((nextToken = this.parser.nextToken()) != JsonToken.END_OBJECT) {
                if (nextToken == null) {
                    LOGGER.warn("Unexpected end of input for row {}.", this.row.values());
                    return this.row;
                }
                switch (nextToken) {
                    case FIELD_NAME: {
                        currentFieldName = this.parser.getText();
                        continue block9;
                    }
                    case VALUE_STRING: {
                        this.setStringValue(currentFieldName, this.parser.getText());
                        continue block9;
                    }
                    case VALUE_NULL: {
                        this.row.set(currentFieldName, "");
                        continue block9;
                    }
                    case VALUE_TRUE: 
                    case VALUE_FALSE: {
                        if (!"_deleted".equals(currentFieldName)) continue block9;
                        this.row.setDeleted(Boolean.parseBoolean(this.parser.getText()));
                        continue block9;
                    }
                    case VALUE_NUMBER_INT: 
                    case VALUE_NUMBER_FLOAT: {
                        if (!"tdpId".equals(currentFieldName)) continue block9;
                        this.row.setTdpId(Long.parseLong(this.parser.getText()));
                        continue block9;
                    }
                }
            }
            this.parser.nextToken();
            return this.row;
        }
        catch (IOException e) {
            throw new TalendRuntimeException((ErrorCode)BaseErrorCodes.UNABLE_TO_PARSE_JSON, (Throwable)e);
        }
    }

    private void setStringValue(String fieldName, String value) {
        if ("tdpId".equals(fieldName)) {
            this.row.setTdpId(Long.parseLong(value));
        } else {
            this.row.set(fieldName, value);
        }
    }
}

