/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.api.dataset.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.api.dataset.row.DataSetRow;

public class DataSetRowStreamSerializer
extends JsonSerializer<Stream<DataSetRow>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSetRowStreamSerializer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(Stream<DataSetRow> value, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeStartArray();
        try {
            value.forEach(row -> {
                try {
                    generator.writeObject(row.valuesWithId());
                }
                catch (IOException e) {
                    LOGGER.error("Unable to write row '{}'", row, (Object)e);
                }
            });
        }
        finally {
            value.close();
        }
        generator.writeEndArray();
    }
}

