/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.api.dataset.row;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang.StringUtils;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.Flag;
import org.talend.dataprep.api.type.Type;

public class DataSetRow
implements Cloneable,
Serializable {
    public static final Predicate<Map.Entry<String, String>> SKIP_TDP_ID = e -> !"tdpId".equals(e.getKey());
    private RowMetadata rowMetadata;
    private Map<String, String> values = new TreeMap<String, String>();
    private boolean deleted;
    private DataSetRow oldValue;
    private Long rowId;
    private final Set<String> invalidColumnIds = new HashSet<String>();

    public DataSetRow(RowMetadata rowMetadata) {
        this.rowMetadata = rowMetadata;
        this.deleted = false;
    }

    public DataSetRow(RowMetadata rowMetadata, Map<String, ?> values) {
        this(rowMetadata);
        values.forEach((k, v) -> this.set((String)k, String.valueOf(v)));
    }

    public DataSetRow(Map<String, String> values) {
        for (Map.Entry<String, String> entry : values.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
        List<ColumnMetadata> columns = values.keySet().stream().map(columnName -> ColumnMetadata.Builder.column().name((String)columnName).type(Type.STRING).build()).collect(Collectors.toList());
        this.rowMetadata = new RowMetadata(columns);
    }

    public RowMetadata getRowMetadata() {
        return this.rowMetadata;
    }

    public void setRowMetadata(RowMetadata rowMetadata) {
        this.rowMetadata = rowMetadata;
    }

    public DataSetRow set(String id, String value) {
        if ("__tdpInvalid".equals(id)) {
            List<String> ids = Arrays.asList(value.split(","));
            this.invalidColumnIds.addAll(ids);
        } else if ("tdpId".equals(id)) {
            this.setTdpId(Long.parseLong(value));
        } else {
            this.values.put(id, value);
        }
        return this;
    }

    public String get(String id) {
        if (StringUtils.startsWith((String)id, (String)"__tdp")) {
            return this.getInternalValues().get(id);
        }
        return this.values.get(id);
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public void diff(DataSetRow oldRow) {
        this.oldValue = oldRow;
    }

    public Map<String, Object> values() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(this.values.size() + 1);
        this.getInternalValues().entrySet().forEach(e -> {
            if (!StringUtils.isEmpty((String)((String)e.getValue()))) {
                this.values.put((String)e.getKey(), (String)e.getValue());
            }
        });
        if (this.oldValue == null) {
            result.putAll(this.values);
            return result;
        }
        if (this.oldValue.isDeleted() && !this.isDeleted()) {
            result.put("__tdpRowDiff", Flag.NEW.getValue());
            result.putAll(this.values);
        } else if (!this.oldValue.isDeleted() && this.isDeleted()) {
            result.put("__tdpRowDiff", Flag.DELETE.getValue());
            result.putAll(this.oldValue.values());
        }
        HashMap diff = new HashMap();
        Map<String, Object> originalValues = this.oldValue.values();
        this.values.entrySet().forEach(entry -> {
            if (!originalValues.containsKey(entry.getKey())) {
                diff.put(entry.getKey(), Flag.NEW.getValue());
            }
        });
        originalValues.entrySet().forEach(entry -> {
            if (!this.values.containsKey(entry.getKey())) {
                diff.put(entry.getKey(), Flag.DELETE.getValue());
                this.set((String)entry.getKey(), (String)entry.getValue());
            }
        });
        this.values.entrySet().forEach(entry -> {
            if (originalValues.containsKey(entry.getKey())) {
                Object originalValue = originalValues.get(entry.getKey());
                if (!StringUtils.equals((String)((String)entry.getValue()), (String)((String)originalValue))) {
                    diff.put(entry.getKey(), Flag.UPDATE.getValue());
                }
            }
        });
        result.putAll(this.values);
        if (!diff.isEmpty()) {
            result.put("__tdpDiff", diff);
        }
        return result;
    }

    public Map<String, Object> valuesWithId() {
        Map<String, Object> temp = this.values();
        if (this.getTdpId() != null) {
            temp.put("tdpId", this.getTdpId());
        }
        return temp;
    }

    public void clear() {
        this.deleted = false;
        this.oldValue = null;
        this.rowId = null;
        this.values.clear();
        this.invalidColumnIds.clear();
    }

    public DataSetRow clone() {
        DataSetRow clone = new DataSetRow(this.rowMetadata, this.values);
        clone.invalidColumnIds.addAll(this.invalidColumnIds);
        clone.setDeleted(this.isDeleted());
        clone.setTdpId(this.rowId);
        return clone;
    }

    public boolean shouldWrite() {
        if (this.oldValue == null) {
            return !this.isDeleted();
        }
        return !this.oldValue.isDeleted() || !this.isDeleted();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSetRow that = (DataSetRow)o;
        return Objects.equals(this.deleted, that.deleted) && Objects.equals(this.values, that.values) && Objects.equals(this.rowId, that.rowId);
    }

    public int hashCode() {
        return Objects.hash(this.deleted, this.values);
    }

    public String toString() {
        return "DataSetRow{rowMetadata=" + this.rowMetadata + ", values=" + this.values + ", deleted=" + this.deleted + ", oldValue=" + this.oldValue + ", rowId=" + this.rowId + '}';
    }

    public DataSetRow order(List<ColumnMetadata> columns) {
        if (columns == null) {
            throw new IllegalArgumentException("Columns cannot be null.");
        }
        if (columns.isEmpty()) {
            return this;
        }
        if (!(columns.size() >= this.values.size() || this.values.containsKey("__tdpInvalid") && columns.size() + 1 >= this.values().size())) {
            throw new IllegalArgumentException("Expected " + this.values.size() + " columns but got " + columns.size());
        }
        LinkedHashMap<String, String> orderedValues = new LinkedHashMap<String, String>();
        for (ColumnMetadata column : columns) {
            String id = column.getId();
            orderedValues.put(id, this.values.get(id));
        }
        DataSetRow dataSetRow = new DataSetRow(this.rowMetadata);
        dataSetRow.values = orderedValues;
        return dataSetRow;
    }

    public DataSetRow order() {
        return this.order(this.getRowMetadata().getColumns());
    }

    public boolean deleteColumnById(String id) {
        this.rowMetadata.deleteColumnById(id);
        if (this.values.containsKey(id)) {
            this.values.remove(id);
            return true;
        }
        return false;
    }

    @SafeVarargs
    public final String[] toArray(Predicate<Map.Entry<String, String>> ... filters) {
        Stream<Map.Entry<String, String>> stream = StreamSupport.stream(this.values.entrySet().spliterator(), false);
        for (Predicate<Map.Entry<String, String>> filter : filters) {
            stream = stream.filter(filter);
        }
        List<String> strings = stream.map(Map.Entry::getValue).map(String::valueOf).collect(Collectors.toList());
        return strings.toArray(new String[strings.size()]);
    }

    public Long getTdpId() {
        return this.rowId;
    }

    public void setTdpId(Long tdpId) {
        this.rowId = tdpId;
    }

    public boolean isEmpty() {
        return this.values.isEmpty() || this.values.values().stream().filter((? super T s) -> !StringUtils.isEmpty((String)s)).count() == 0L;
    }

    public DataSetRow unmodifiable() {
        return new UnmodifiableDataSetRow(this);
    }

    public DataSetRow modifiable() {
        return this;
    }

    public DataSetRow filter(List<ColumnMetadata> filteredColumns) {
        Set columnsToKeep = filteredColumns.stream().map(ColumnMetadata::getId).collect(Collectors.toSet());
        Set columnsToDelete = this.values.entrySet().stream().filter((? super T e) -> !columnsToKeep.contains(e.getKey())).map(Map.Entry::getKey).collect(Collectors.toSet());
        RowMetadata rowMetadataClone = this.rowMetadata.clone();
        LinkedHashMap<String, String> filteredValues = new LinkedHashMap<String, String>(this.values);
        for (String columnId : columnsToDelete) {
            filteredValues.remove(columnId);
            rowMetadataClone.deleteColumnById(columnId);
        }
        DataSetRow filteredDataSetRow = new DataSetRow(rowMetadataClone, filteredValues);
        filteredDataSetRow.invalidColumnIds.addAll(this.invalidColumnIds);
        return filteredDataSetRow;
    }

    public boolean isInvalid(String columnId) {
        String currentInvalidColumnIds = this.get("__tdpInvalid");
        return currentInvalidColumnIds != null && currentInvalidColumnIds.contains(columnId);
    }

    public void setInvalid(String columnId) {
        this.invalidColumnIds.add(columnId);
    }

    public void unsetInvalid(String columnId) {
        this.invalidColumnIds.remove(columnId);
    }

    public Map<String, String> getInternalValues() {
        HashMap<String, String> internalValues = new HashMap<String, String>(1);
        internalValues.put("__tdpInvalid", this.invalidColumnIds.stream().collect(Collectors.joining(",")));
        return internalValues;
    }

    private static class UnmodifiableDataSetRow
    extends DataSetRow {
        private final DataSetRow delegate;
        private final boolean deleted;

        private UnmodifiableDataSetRow(DataSetRow delegate) {
            super(delegate.rowMetadata);
            this.delegate = delegate;
            this.deleted = delegate.isDeleted();
        }

        @Override
        public RowMetadata getRowMetadata() {
            return this.delegate.getRowMetadata();
        }

        @Override
        public DataSetRow set(String id, String value) {
            if (this.delegate.get(id) == null) {
                return this.delegate.set(id, "");
            }
            return this;
        }

        @Override
        public String get(String id) {
            return this.delegate.get(id);
        }

        @Override
        public boolean isDeleted() {
            return this.deleted;
        }

        @Override
        public void setDeleted(boolean deleted) {
        }

        @Override
        public void diff(DataSetRow oldRow) {
            this.delegate.diff(oldRow);
        }

        @Override
        public Map<String, Object> values() {
            return Collections.unmodifiableMap(this.delegate.values());
        }

        @Override
        public Map<String, Object> valuesWithId() {
            return Collections.unmodifiableMap(this.delegate.valuesWithId());
        }

        @Override
        public void clear() {
        }

        @Override
        public DataSetRow clone() {
            return this;
        }

        @Override
        public boolean shouldWrite() {
            return this.delegate.shouldWrite();
        }

        @Override
        public boolean equals(Object o) {
            return this.delegate.equals(o);
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public DataSetRow order(List<ColumnMetadata> columns) {
            return this.delegate.order(columns);
        }

        @Override
        public Long getTdpId() {
            return this.delegate.getTdpId();
        }

        @Override
        public void setTdpId(Long tdpId) {
        }

        @Override
        public DataSetRow unmodifiable() {
            return this;
        }

        @Override
        public DataSetRow modifiable() {
            return this.delegate;
        }
    }
}

