/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.api.dataset.row;

import java.util.BitSet;
import java.util.List;
import java.util.function.Function;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataquality.common.inference.Analyzer;
import org.talend.dataquality.common.inference.Analyzers;
import org.talend.dataquality.common.inference.ValueQualityStatistics;

public class InvalidMarker
implements Function<DataSetRow, DataSetRow> {
    private final long[] invalidCount;
    private final Analyzer<Analyzers.Result> analyzer;
    private final List<ColumnMetadata> columns;

    public InvalidMarker(List<ColumnMetadata> columns, Analyzer<Analyzers.Result> analyzer) {
        this.columns = columns;
        this.invalidCount = new long[columns.size()];
        this.analyzer = analyzer;
    }

    @Override
    public DataSetRow apply(DataSetRow dataSetRow) {
        int i;
        String[] values = dataSetRow.filter(this.columns).order(this.columns).toArray(DataSetRow.SKIP_TDP_ID);
        this.analyzer.analyze(values);
        List columnsAnalysis = this.analyzer.getResult();
        BitSet invalidBitSet = new BitSet(values.length);
        for (i = 0; i < columnsAnalysis.size(); ++i) {
            long newInvalidCount;
            Analyzers.Result columnAnalysis = (Analyzers.Result)columnsAnalysis.get(i);
            if (!columnAnalysis.exist(ValueQualityStatistics.class) || (newInvalidCount = ((ValueQualityStatistics)columnAnalysis.get(ValueQualityStatistics.class)).getInvalidCount()) <= this.invalidCount[i]) continue;
            invalidBitSet.set(i);
            this.invalidCount[i] = newInvalidCount;
        }
        for (i = 0; i < this.columns.size(); ++i) {
            String columnId = this.columns.get(i).getId();
            if (invalidBitSet.get(i)) {
                dataSetRow.setInvalid(columnId);
                continue;
            }
            dataSetRow.unsetInvalid(columnId);
        }
        return dataSetRow;
    }
}

