/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.api.dataset.row;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.statistics.PatternFrequency;
import org.talend.dataprep.api.type.Type;

public class RowMetadataUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RowMetadataUtils.class);
    private static final String DATAPREP_FIELD_PREFIX = "DP_";
    private static final ObjectMapper mapper = new ObjectMapper();

    private RowMetadataUtils() {
    }

    public static Schema toSchema(RowMetadata rowMetadata) {
        return RowMetadataUtils.toSchema(rowMetadata.getColumns());
    }

    public static Schema toSchema(String name, RowMetadata rowMetadata) {
        return RowMetadataUtils.toSchema(name, rowMetadata.getColumns());
    }

    public static Schema toSchema(List<ColumnMetadata> columns) {
        return RowMetadataUtils.toSchema("dataprep" + System.currentTimeMillis(), columns);
    }

    public static Schema toSchema(String name, List<ColumnMetadata> columns) {
        HashMap uniqueSuffixes = new HashMap();
        List fields = columns.stream().peek(columnMetadata -> {
            Integer suffix = (Integer)uniqueSuffixes.get(columnMetadata.getName());
            if (suffix != null) {
                uniqueSuffixes.put(columnMetadata.getName(), suffix + 1);
                columnMetadata.setName(columnMetadata.getName() + '_' + suffix);
            } else {
                uniqueSuffixes.put(columnMetadata.getName(), 1);
            }
        }).map(RowMetadataUtils::toField).collect(Collectors.toList());
        Schema schema = Schema.createRecord((String)name, (String)"a dataprep preparation", (String)"org.talend.dataprep", (boolean)false);
        schema.setFields(fields);
        return schema;
    }

    public static Schema.Field toField(ColumnMetadata column) {
        String name = column.getName() == null ? DATAPREP_FIELD_PREFIX + column.getId() : RowMetadataUtils.toAvroFieldName(column);
        Schema.Field field = new Schema.Field(name, Schema.create((Schema.Type)Schema.Type.STRING), "", null);
        try {
            StringWriter writer = new StringWriter();
            mapper.writerWithType(ColumnMetadata.class).writeValue((Writer)writer, (Object)column);
            field.addProp("_dp_column", writer.toString());
        }
        catch (IOException e) {
            LOGGER.error("Unable to add column metadata to field '{}'.", (Object)name, (Object)e);
        }
        return field;
    }

    public static String toAvroFieldName(ColumnMetadata column) {
        char[] chars = column.getName().toCharArray();
        StringBuilder columnName = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            char currentChar = chars[i];
            if (i == 0) {
                if (!Character.isLetter(currentChar)) {
                    columnName.append(DATAPREP_FIELD_PREFIX);
                } else if (!Character.isJavaIdentifierPart(currentChar)) {
                    columnName.append('_');
                } else {
                    columnName.append(currentChar);
                }
            }
            if (i <= 0) continue;
            if (!Character.isJavaIdentifierPart(currentChar)) {
                columnName.append('_');
                continue;
            }
            columnName.append(currentChar);
        }
        return columnName.toString();
    }

    public static String getMostUsedDatePattern(ColumnMetadata column) {
        if (Type.get(column.getType()) != Type.DATE) {
            return null;
        }
        Optional<PatternFrequency> electedPattern = column.getStatistics().getPatternFrequencies().stream().filter(p -> !StringUtils.isEmpty((String)p.getPattern())).sorted((p1, p2) -> Long.compare(p2.getOccurrences(), p1.getOccurrences())).findFirst();
        if (electedPattern.isPresent()) {
            return electedPattern.get().getPattern();
        }
        return null;
    }
}

