/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.api.dataset.statistics;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;

public class Quantiles
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="median")
    private double median = Double.NaN;
    @JsonProperty(value="lowerQuantile")
    private double lowerQuantile = Double.NaN;
    @JsonProperty(value="upperQuantile")
    private double upperQuantile = Double.NaN;

    Quantiles() {
    }

    Quantiles(Quantiles originalQuantiles) {
        this.median = originalQuantiles.median;
        this.lowerQuantile = originalQuantiles.lowerQuantile;
        this.upperQuantile = originalQuantiles.upperQuantile;
    }

    public double getMedian() {
        return this.median;
    }

    public void setMedian(double median) {
        this.median = median;
    }

    public double getLowerQuantile() {
        return this.lowerQuantile;
    }

    public void setLowerQuantile(double lowerQuantile) {
        this.lowerQuantile = lowerQuantile;
    }

    public double getUpperQuantile() {
        return this.upperQuantile;
    }

    public void setUpperQuantile(double upperQuantile) {
        this.upperQuantile = upperQuantile;
    }

    public String toString() {
        return "Quantiles{median=" + this.median + ", lowerQuantile=" + this.lowerQuantile + ", upperQuantile=" + this.upperQuantile + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Quantiles)) {
            return false;
        }
        Quantiles quantiles = (Quantiles)o;
        if (Double.compare(quantiles.median, this.median) != 0) {
            return false;
        }
        if (Double.compare(quantiles.lowerQuantile, this.lowerQuantile) != 0) {
            return false;
        }
        return Double.compare(quantiles.upperQuantile, this.upperQuantile) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.median);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.lowerQuantile);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.upperQuantile);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

