/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.api.dataset.statistics;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.talend.dataprep.api.dataset.statistics.DataFrequency;
import org.talend.dataprep.api.dataset.statistics.Histogram;
import org.talend.dataprep.api.dataset.statistics.PatternFrequency;
import org.talend.dataprep.api.dataset.statistics.Quantiles;
import org.talend.dataprep.api.dataset.statistics.TextLengthSummary;

@JsonRootName(value="statistics")
public class Statistics
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="count")
    private long count;
    @JsonProperty(value="valid")
    private long valid;
    @JsonProperty(value="invalid")
    private long invalid;
    @JsonProperty(value="empty")
    private long empty;
    @JsonProperty(value="max")
    private double max = 0.0;
    @JsonProperty(value="min")
    private double min = 0.0;
    @JsonProperty(value="mean")
    private double mean = 0.0;
    @JsonProperty(value="variance")
    private double variance = 0.0;
    @JsonProperty(value="duplicateCount")
    private long duplicateCount = 0L;
    @JsonProperty(value="distinctCount")
    private long distinctCount = 0L;
    @JsonProperty(value="frequencyTable")
    private List<DataFrequency> dataFrequencies = new LinkedList<DataFrequency>();
    @JsonProperty(value="patternFrequencyTable")
    private List<PatternFrequency> patternFrequencies = new LinkedList<PatternFrequency>();
    @JsonProperty(value="quantiles")
    private Quantiles quantiles = new Quantiles();
    @JsonProperty(value="histogram")
    private Histogram histogram;
    @JsonProperty(value="textLengthSummary")
    private TextLengthSummary textLengthSummary = new TextLengthSummary();

    public Statistics() {
    }

    public Statistics(Statistics original) {
        this.count = original.count;
        this.valid = original.valid;
        this.invalid = original.invalid;
        this.empty = original.empty;
        this.max = original.max;
        this.min = original.min;
        this.mean = original.mean;
        this.variance = original.variance;
        this.distinctCount = original.distinctCount;
        this.duplicateCount = original.duplicateCount;
        this.dataFrequencies = new LinkedList<DataFrequency>(original.dataFrequencies);
        this.patternFrequencies = new LinkedList<PatternFrequency>(original.patternFrequencies);
        this.quantiles = original.quantiles == null ? new Quantiles() : new Quantiles(original.quantiles);
        this.histogram = original.histogram;
        this.textLengthSummary = original.textLengthSummary == null ? new TextLengthSummary() : new TextLengthSummary(original.textLengthSummary);
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public long getValid() {
        return this.valid;
    }

    public void setValid(long valid) {
        this.valid = valid;
    }

    public long getInvalid() {
        return this.invalid;
    }

    public void setInvalid(long invalid) {
        this.invalid = invalid;
    }

    public long getEmpty() {
        return this.empty;
    }

    public void setEmpty(long empty) {
        this.empty = empty;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getMean() {
        return this.mean;
    }

    public void setMean(double mean) {
        this.mean = mean;
    }

    public double getVariance() {
        return this.variance;
    }

    public void setVariance(double variance) {
        this.variance = variance;
    }

    public long getDuplicateCount() {
        return this.duplicateCount;
    }

    public void setDuplicateCount(long duplicateCount) {
        this.duplicateCount = duplicateCount;
    }

    public long getDistinctCount() {
        return this.distinctCount;
    }

    public void setDistinctCount(long distinctCount) {
        this.distinctCount = distinctCount;
    }

    public List<DataFrequency> getDataFrequencies() {
        return this.dataFrequencies;
    }

    public void setDataFrequencies(List<DataFrequency> dataFrequencies) {
        this.dataFrequencies = dataFrequencies;
    }

    public List<PatternFrequency> getPatternFrequencies() {
        return this.patternFrequencies;
    }

    public void setPatternFrequencies(List<PatternFrequency> patternFrequencies) {
        this.patternFrequencies = patternFrequencies;
    }

    public Quantiles getQuantiles() {
        return this.quantiles;
    }

    public void setQuantiles(Quantiles quantiles) {
        this.quantiles = quantiles;
    }

    public Histogram getHistogram() {
        return this.histogram;
    }

    public void setHistogram(Histogram histogram) {
        this.histogram = histogram;
    }

    public TextLengthSummary getTextLengthSummary() {
        return this.textLengthSummary;
    }

    public void setTextLengthSummary(TextLengthSummary textLengthSummary) {
        this.textLengthSummary = textLengthSummary;
    }

    public String toString() {
        return "Statistics{count=" + this.count + ", valid=" + this.valid + ", invalid=" + this.invalid + ", empty=" + this.empty + ", max=" + this.max + ", min=" + this.min + ", mean=" + this.mean + ", variance=" + this.variance + ", duplicateCount=" + this.duplicateCount + ", distinctCount=" + this.distinctCount + ", dataFrequencies=" + this.dataFrequencies + ", patternFrequencies=" + this.patternFrequencies + ", quantiles=" + this.quantiles + ", histogram=" + this.histogram + ", textLengthSummary=" + this.textLengthSummary + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Statistics)) {
            return false;
        }
        Statistics that = (Statistics)o;
        if (this.count != that.count) {
            return false;
        }
        if (this.valid != that.valid) {
            return false;
        }
        if (this.invalid != that.invalid) {
            return false;
        }
        if (this.empty != that.empty) {
            return false;
        }
        if (Double.compare(that.max, this.max) != 0) {
            return false;
        }
        if (Double.compare(that.min, this.min) != 0) {
            return false;
        }
        if (Double.compare(that.mean, this.mean) != 0) {
            return false;
        }
        if (Double.compare(that.variance, this.variance) != 0) {
            return false;
        }
        if (this.duplicateCount != that.duplicateCount) {
            return false;
        }
        if (this.distinctCount != that.distinctCount) {
            return false;
        }
        if (!new HashSet<DataFrequency>(this.dataFrequencies).equals(new HashSet<DataFrequency>(that.dataFrequencies))) {
            return false;
        }
        if (!new HashSet<PatternFrequency>(this.patternFrequencies).equals(new HashSet<PatternFrequency>(that.patternFrequencies))) {
            return false;
        }
        if (!this.quantiles.equals(that.quantiles)) {
            return false;
        }
        if (this.histogram == null && that.histogram != null || this.histogram != null && !this.histogram.equals(that.histogram)) {
            return false;
        }
        return this.textLengthSummary.equals(that.textLengthSummary);
    }

    public int hashCode() {
        int result = (int)(this.count ^ this.count >>> 32);
        result = 31 * result + (int)(this.valid ^ this.valid >>> 32);
        result = 31 * result + (int)(this.invalid ^ this.invalid >>> 32);
        result = 31 * result + (int)(this.empty ^ this.empty >>> 32);
        long temp = Double.doubleToLongBits(this.max);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.min);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.mean);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.variance);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (int)(this.duplicateCount ^ this.duplicateCount >>> 32);
        result = 31 * result + (int)(this.distinctCount ^ this.distinctCount >>> 32);
        result = 31 * result + this.dataFrequencies.hashCode();
        result = 31 * result + this.patternFrequencies.hashCode();
        result = 31 * result + this.quantiles.hashCode();
        result = 31 * result + this.histogram.hashCode();
        result = 31 * result + this.textLengthSummary.hashCode();
        return result;
    }
}

