/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.api.dataset.statistics.date;

import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.api.dataset.statistics.date.StreamDateHistogramStatistics;
import org.talend.dataprep.transformation.actions.date.DateParser;
import org.talend.dataquality.common.inference.Analyzer;
import org.talend.dataquality.common.inference.ResizableList;
import org.talend.dataquality.statistics.type.DataTypeEnum;
import org.talend.dataquality.statistics.type.TypeInferenceUtils;

public class StreamDateHistogramAnalyzer
implements Analyzer<StreamDateHistogramStatistics> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamDateHistogramAnalyzer.class);
    private final ResizableList<StreamDateHistogramStatistics> stats = new ResizableList(StreamDateHistogramStatistics.class);
    private final DataTypeEnum[] types;
    private final DateParser dateParser;
    private final List<ColumnMetadata> columns;

    public StreamDateHistogramAnalyzer(List<ColumnMetadata> columns, DataTypeEnum[] types, DateParser dateParser) {
        this.columns = columns;
        this.types = types;
        this.dateParser = dateParser;
    }

    public boolean analyze(String ... record) {
        if (record.length != this.types.length) {
            throw new IllegalArgumentException("Each column of the record should be declared a DataType.Type corresponding! \n" + this.types.length + " type(s) declared in this histogram analyzer but " + record.length + " column(s) was found in this record. \n" + "Using method: setTypes(DataType.Type[] types) to set the types. ");
        }
        this.stats.resize(record.length);
        for (int index = 0; index < this.types.length; ++index) {
            DataTypeEnum type = this.types[index];
            ColumnMetadata column = this.columns.get(index);
            String value = record[index];
            if (type != DataTypeEnum.DATE) continue;
            String mostUsedDatePattern = RowMetadataUtils.getMostUsedDatePattern(column);
            if (!TypeInferenceUtils.isDate((String)value, Collections.singletonList(mostUsedDatePattern))) {
                LOGGER.trace("Skip date value '{}' (not valid date)", (Object)value);
                continue;
            }
            try {
                LocalDateTime adaptedValue = this.dateParser.parse(value, column);
                ((StreamDateHistogramStatistics)this.stats.get(index)).add(adaptedValue);
                continue;
            }
            catch (DateTimeException e) {
                LOGGER.debug("Unable to process date value '{}'", (Object)value, (Object)e);
            }
        }
        return true;
    }

    public Analyzer<StreamDateHistogramStatistics> merge(Analyzer<StreamDateHistogramStatistics> another) {
        throw new NotImplementedException();
    }

    public void end() {
    }

    public List<StreamDateHistogramStatistics> getResult() {
        return this.stats;
    }

    public void init() {
    }

    public void close() throws Exception {
    }
}

