/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.api.dataset.statistics.date;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.talend.dataprep.api.dataset.statistics.Histogram;
import org.talend.dataprep.api.dataset.statistics.HistogramRange;
import org.talend.dataprep.api.dataset.statistics.Range;
import org.talend.dataprep.api.dataset.statistics.date.DateHistogram;
import org.talend.dataprep.date.DateManipulator;

public class StreamDateHistogramStatistics {
    private static final int DEFAULT_BIN_NUMBER = 16;
    private int numberOfBins = 16;
    private final Map<DateManipulator.Pace, Map<Range, Long>> bins = new HashMap<DateManipulator.Pace, Map<Range, Long>>();
    private LocalDateTime min;
    private LocalDateTime max;

    public StreamDateHistogramStatistics() {
        Arrays.stream(DateManipulator.Pace.values()).forEach(pace -> {
            Map cfr_ignored_0 = this.bins.put((DateManipulator.Pace)((Object)pace), new HashMap());
        });
    }

    public void add(LocalDateTime date) {
        try (Stream<DateManipulator.Pace> stream = Arrays.stream(DateManipulator.Pace.values());){
            stream.forEach(pace -> this.add((DateManipulator.Pace)((Object)pace), date));
        }
        this.refreshLimits(date);
    }

    private void add(DateManipulator.Pace pace, LocalDateTime date) {
        long endTimestamp;
        Range range;
        Map<Range, Long> paceBins = this.bins.get((Object)pace);
        if (paceBins == null) {
            return;
        }
        LocalDateTime startDate = DateManipulator.getSuitableStartingDate(date, pace);
        LocalDateTime endDate = DateManipulator.getNext(startDate, pace);
        long startTimestamp = DateManipulator.getUTCEpochMilliseconds(startDate);
        Long nbInBin = paceBins.get(range = new Range(startTimestamp, endTimestamp = DateManipulator.getUTCEpochMilliseconds(endDate)));
        paceBins.put(range, (nbInBin != null ? nbInBin : 0L) + 1L);
        if (paceBins.size() > this.numberOfBins) {
            this.bins.remove((Object)pace);
        }
    }

    private void refreshLimits(LocalDateTime date) {
        if (this.min == null || date.isBefore(this.min)) {
            this.min = date;
        }
        if (this.max == null || date.isAfter(this.max)) {
            this.max = date;
        }
    }

    public Histogram getHistogram() {
        DateHistogram histogram = new DateHistogram();
        if (this.min == null) {
            return histogram;
        }
        DateManipulator.Pace pace = DateManipulator.getSuitablePace(this.min, this.max, this.numberOfBins);
        Map<Range, Long> paceBin = this.bins.get((Object)pace);
        if (paceBin == null) {
            return histogram;
        }
        histogram.setPace(pace);
        LocalDateTime nextRangeStart = DateManipulator.getSuitableStartingDate(this.min, pace);
        while (this.max.isAfter(nextRangeStart) || this.max.equals(nextRangeStart)) {
            LocalDateTime rangeStart = nextRangeStart;
            LocalDateTime rangeEnd = DateManipulator.getNext(nextRangeStart, pace);
            long rangeStartTimestamp = DateManipulator.getUTCEpochMilliseconds(rangeStart);
            long rangeEndTimestamp = DateManipulator.getUTCEpochMilliseconds(rangeEnd);
            Range range = new Range(rangeStartTimestamp, rangeEndTimestamp);
            Long rangeValue = paceBin.get(range);
            HistogramRange dateRange = new HistogramRange();
            dateRange.setRange(range);
            dateRange.setOccurrences(rangeValue != null ? rangeValue : 0L);
            histogram.getItems().add(dateRange);
            nextRangeStart = rangeEnd;
        }
        histogram.setMinUTCEpochMilliseconds(this.minUTCEpochMilliseconds());
        histogram.setMaxUTCEpochMilliseconds(this.maxUTCEpochMilliseconds());
        return histogram;
    }

    public void setNumberOfBins(int numberOfBins) {
        if (numberOfBins <= 0) {
            throw new IllegalArgumentException("The number of bin must be a positive integer");
        }
        this.numberOfBins = numberOfBins;
    }

    private long minUTCEpochMilliseconds() {
        return DateManipulator.getUTCEpochMilliseconds(this.min);
    }

    private long maxUTCEpochMilliseconds() {
        return DateManipulator.getUTCEpochMilliseconds(this.max);
    }
}

